# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name solarus
%define major		1
%define libname		lib%{name}%{major}
%define develname	lib%{name}-devel

Name:		solarus
Version:	1.6.4
Release:	alt1_2
Summary:	An open-source Zelda-like 2D game engine
Group:		Games/Adventure
License:	GPLv3
URL:		http://www.solarus-games.org/
Source0:	https://gitlab.com/solarus-games/solarus/-/archive/v%{version}/%{name}-%{version}.tar.bz2

BuildRequires:	ccmake cmake ctest
BuildRequires:	qt5-designer qt5-tools
BuildRequires:	pkgconfig(glm)
BuildRequires:	pkgconfig(physfs)
BuildRequires:	pkgconfig(libmodplug)
BuildRequires:	pkgconfig(luajit)
BuildRequires:	pkgconfig(openal)
BuildRequires:	pkgconfig(sdl2)
BuildRequires:	pkgconfig(SDL2_image)
BuildRequires:	pkgconfig(SDL2_ttf)
BuildRequires:	pkgconfig(vorbis)
BuildRequires:	pkgconfig(Qt5Core)
BuildRequires:	pkgconfig(Qt5Gui)
BuildRequires:	pkgconfig(Qt5Help)
BuildRequires:	pkgconfig(Qt5Widgets)
Source44: import.info

%description
Solarus is an open-source Zelda-like 2D game engine written in C++.

If you want, you can download games "Zelda Mystery of Solarus DX"
and "Zelda Mystery of Solarus XD" on solarus site at :
http://www.solarus-games.org/games/ .

Their licenses do not allow redistribution, they are open-source but
contain copyrighted material from Nintendo, thus preventing their
redistribution as per Mageia's licensing policy.

#------------------------------------------------

%package -n	%{libname}
Summary:	Runtime library for %{name}
Group:		System/Libraries

%description -n	%{libname}
This package contains library files for %{name}.

#------------------------------------------------

%package -n	%{develname}
Summary:	Development files for %{name}
Group:		Development/C++
Requires:	%{libname} = %{version}-%{release}
Provides:	%{name}-devel = %{version}-%{release}
Provides:	lib%{name}-devel = %{version}-%{release}

%description -n	%{develname}
The %{develname} package contains libraries and header files for
developing applications that use %{name}.

#------------------------------------------------

%prep
%setup -q


%build
%{mageia_cmake}

%mageia_cmake_build

%install
%mageia_cmake_install

%files
%doc changelog.txt readme.md
%doc --no-dereference license.txt
%{_bindir}/%{name}-launcher
%{_bindir}/%{name}-run
%{_datadir}/%{name}-gui/
%{_datadir}/applications/%{name}-launcher.desktop
%{_datadir}/appdata/%{name}-launcher.appdata.xml
%{_datadir}/pixmaps/%{name}-launcher.png
%{_iconsdir}/hicolor/*/apps/%{name}-launcher.png
%{_iconsdir}/hicolor/*/apps/%{name}-launcher*.svg
%{_mandir}/man6/%{name}-launcher.6*
%{_mandir}/man6/%{name}-run.6*

%files -n %{libname}
%{_libdir}/lib%{name}.so.%{major}*
%{_libdir}/lib%{name}-gui.so.%{major}*

%files -n %{develname}
%{_includedir}/%{name}/
%{_libdir}/lib%{name}.so
%{_libdir}/lib%{name}-gui.so


%changelog
