Group: Other
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
BuildRequires: /usr/bin/git
%bcond_without vmguestlib

Name: spausedd
Summary: Utility to detect and log scheduler pause
Version: 20210719
Release: alt1_11
License: ISC
URL: https://github.com/jfriesse/spausedd
Source0: https://github.com/jfriesse/%{name}/releases/download/%{version}/%{name}-%{version}.tar.gz

# VMGuestLib exists only for x86 architectures (for Fedora) and x86_64 (for RHEL)
%if %{with vmguestlib}
%if 0%{?rhel} >= 6
%ifarch x86_64
%global use_vmguestlib 1
%endif
%else
%ifarch %{ix86} x86_64
%global use_vmguestlib 1
%endif
%endif
%endif

BuildRequires: gcc
BuildRequires: git
%{?systemd_requires}
BuildRequires: libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd

%if %{defined use_vmguestlib}
BuildRequires: pkgconfig(vmguestlib)
%endif
Source44: import.info

%description
Utility to detect and log scheduler pause

%prep
%setup -q
git init -q
git config user.name "rpmbuild"
git config user.email "<rpmbuild>"
git config gc.auto 0
git add --force .
git commit -q --allow-empty -a --author "rpmbuild <rpmbuild>" -m "%{NAME}-%{VERSION} base"


%build

%make_build \
%if %{defined use_vmguestlib}
    WITH_VMGUESTLIB=1 \
%else
    WITH_VMGUESTLIB=0 \
%endif

%install
%makeinstall_std PREFIX="%{_prefix}"

mkdir -p %{buildroot}/%{_unitdir}
install -m 644 -p init/%{name}.service %{buildroot}/%{_unitdir}

%files
%doc AUTHORS
%doc --no-dereference COPYING
%{_bindir}/%{name}
%{_mandir}/man8/*
%{_unitdir}/spausedd.service

%post
%post_service spausedd

%preun
%preun_service spausedd

%changelog
