Group: System/Base
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:       spin-kickstarts
Version:    0.36.0
Release:    alt1_0.4
License:    GPLv2+
Summary:    Kickstart files and templates for creating your own Fedora Spins
URL:        https://pagure.io/fedora-kickstarts
Source0:    https://pagure.io/fedora-kickstarts/archive/%{version}/fedora-kickstarts-%{version}.tar.gz
BuildArch:  noarch
Requires:   fedora-kickstarts
Source44: import.info

%description
A number of kickstarts you can use to create customized (Fedora) Spins

%package -n fedora-kickstarts
Group: System/Base
Summary:    Official Fedora Spins
Requires:   spin-kickstarts = %{version}-%{release}

%description -n fedora-kickstarts
Kickstarts used to compose the official Fedora Spins (see
http://spins.fedoraproject.org/ for a full list)

%package -n custom-kickstarts
Group: System/Base
Summary:    Kickstart files for Custom Spins (not official)
Requires:   spin-kickstarts = %{version}-%{release}
Requires:   fedora-kickstarts = %{version}-%{release}

%description -n custom-kickstarts
Unofficial spins (remixes) brought to us by several contributors

%package -n l10n-kickstarts
Group: System/Base
Summary:    Localized kickstarts for localized spins
Requires:   fedora-kickstarts = %{version}-%{release}
Requires:   custom-kickstarts = %{version}-%{release}

%description -n l10n-kickstarts
Localized versions of kickstarts for localized spins

%prep
%setup -q -n fedora-kickstarts-%{version}

%build

%install
make install DESTDIR=$RPM_BUILD_ROOT/usr

%files
%doc COPYING README.md AUTHORS
%dir %{_datadir}/%{name}/

%files -n fedora-kickstarts
%{_datadir}/%{name}/*.ks*
%{_datadir}/%{name}/snippets/

%files -n custom-kickstarts
%dir %{_datadir}/%{name}/custom/
%{_datadir}/%{name}/custom/*.ks
%{_datadir}/%{name}/custom/*.js
%doc %{_datadir}/%{name}/custom/README

%files -n l10n-kickstarts
%dir %{_datadir}/%{name}/l10n/
%{_datadir}/%{name}/l10n/*.ks
%doc %{_datadir}/%{name}/l10n/README

%changelog
