Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: python3(toml)
# END SourceDeps(oneline)
%filter_from_requires /python3(sshuttle.cmdline_options)/d
%define fedora 34
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:               sshuttle
Version:            1.1.0
Release:            alt1_2
Summary:            Transparent Proxy VPN
Source0:            https://files.pythonhosted.org/packages/source/s/%{name}/%{name}-%{version}.tar.gz
URL:                https://github.com/%{name}/%{name}
License:            LGPLv2+
BuildArch:          noarch

BuildRequires:      python3-devel
BuildRequires:      python3-module-pkg_resources python3-module-setuptools
BuildRequires:      python3-module-setuptools_scm
BuildRequires:      python3-module-sphinx python3-module-sphinx-sphinx-build-symlink
BuildRequires:      makeinfo

%if 0%{?fedora}
# For tests on fedora
# We don't run tests on epel due to missing requirements
BuildRequires:      python3-module-mock
BuildRequires:      pytest3 python3-module-pytest
BuildRequires:      python3-module-pytest-cov
BuildRequires:      python3-module-pytest-runner
BuildRequires:      python3-module-pytest-mock
BuildRequires:      python3-module-psutil
BuildRequires:      python3-module-flake8
%endif

Requires:           iptables
Requires:           openssh-clients
Source44: import.info

%description
Transparent proxy server that works as a poor man's VPN. Forwards over ssh.
Doesn't require admin. Works with Linux and MacOS. Supports DNS tunneling.

%prep
%setup -q -n %{name}-%{version}


# This file is a script, so shouldn't be installed under
# site-packages. We'll remove it for now.
rm %{name}/stresstest.py


%build
%python3_build

# Build docs
pushd docs
make man
make info
popd


%install
%python3_install

# Install docs
pushd docs
# Man
mkdir -p %{buildroot}/%{_mandir}/man1
mv _build/man/%{name}.1 %{buildroot}/%{_mandir}/man1
# Info
mkdir -p %{buildroot}/%{_infodir}
mv _build/texinfo/%{name}.info %{buildroot}/%{_infodir}
popd


%check
%if 0%{?fedora}
%{__python3} setup.py test
%endif

%files
%doc --no-dereference LICENSE
%{_mandir}/man1/%{name}.1*
%{_infodir}/%{name}.info.*
%{python3_sitelibdir_noarch}/%{name}
%{python3_sitelibdir_noarch}/%{name}*.egg-info
%{_bindir}/sshuttle
%{_bindir}/sudoers-add


%changelog
