Group: System/Base
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary: Transparent and scalable SSL/TLS interception
Name: sslsplit
Version: 0.5.5
Release: alt3_17
# Automatically converted from old format: BSD - review is highly recommended.
License: LicenseRef-Callaway-BSD
Url: http://www.roe.ch/SSLsplit
Source: http://mirror.roe.ch/rel/sslsplit/sslsplit-%{version}.tar.bz2

# https://github.com/droe/sslsplit/commit/e17de8454a65d2b9ba432856971405dfcf1e7522
Patch1: sslsplit-0.5.5-openssl3.patch

Buildrequires: libevent-devel, libssl-devel, libcheck-devel gcc
%if 0%{?fedora} >= 41
BuildRequires:  libssl-devel
%endif
Buildrequires: libpcap-devel libnet2-devel
Requires: iptables, iproute2
Source44: import.info

%description
SSLsplit is a tool for man-in-the-middle attacks against SSL/TLS encrypted
network connections. Connections are transparently intercepted through a
network address translation engine and redirected to SSLsplit. SSLsplit
terminates SSL/TLS and initiates a new SSL/TLS connection to the original
destination address, while logging all data transmitted. SSLsplit is
intended to be useful for network forensics and penetration testing.

It uses Linux netfilter REDIRECT and TPROXY

%prep
%setup -q
%patch1 -p1


%build
# work around some odd build system option passing
export CFLAGS="%{optflags}"
export DEBUG_CFLAGS="%{optflags}"
%make_build

%install
mkdir -p %{buildroot}%{_bindir} %{buildroot}%{_mandir}/man1/
cp -a %{name} %{buildroot}%{_bindir}
cp -a %{name}.1  %{buildroot}%{_mandir}/man1/

%files
%attr(0755,root,root) %{_bindir}/%{name}
%doc *.md
%{_mandir}/*/*

%changelog
