# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# -*- mode: rpm-spec ; mode: font-lock -*-

Summary: Macromolecular coordinate superposition library
Name: ssm
Version: 1.1
Release: alt1_5
License: LGPLv2+
Group: System/Libraries
URL: https://launchpad.net/ssm
Source0: http://launchpad.net/%{name}/trunk/%{version}/+download/%{name}-%{version}.tar.gz
Patch0: ssm-configure.ac.patch
Patch1: ssm-makefile.am.patch
Patch2: ssm-ssm.pc.in.patch
Patch3: ssm-mattype.patch
BuildRequires: autoconf
BuildRequires: automake
BuildRequires: libtool
BuildRequires: mmdb-devel
Source44: import.info

%description
SSM is a macromolecular coordinate superposition library, written by 
Eugene Krissinel.

The library implements the SSM algorithm of protein structure
comparison in three dimensions, which includes an original procedure
of matching graphs built on the protein's secondary-structure
elements, followed by an iterative three-dimensional alignment of
protein backbone Calpha atoms. 

The algorithm implemented by the software is described in:
E. Krissinel & K. Henrick (2004) Secondary-structure matching (SSM), a
new tool for fast protein structure alignment in three dimensions.
Acta Crystallogr D Biol Crystallogr. 60, 2256-68.

This package contains the shared library components needed for programs
that have been compiled with the ssm library. 

%package devel
Summary: Header files and library for developing programs with ssm
Requires: %{name} = %{version}-%{release}
Group: Development/C

%description devel
This package contains libraries and header files needed for program
development using SSM.

%prep
%setup -q
%patch0 -p0
%patch1 -p0
%patch2 -p0
%patch3 -p0
aclocal
libtoolize --automake --copy
autoconf
automake --copy --add-missing --gnu

%build
%configure --disable-static
make %{?_smp_mflags}

%install
make install DESTDIR=$RPM_BUILD_ROOT INSTALL='install -p'

# remove unpackaged files from the buildroot
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

%files
%doc AUTHORS COPYING README
%{_libdir}/libssm.so.0.0.0
%{_libdir}/libssm.so.0

%files devel
%{_libdir}/libssm.so
%{_includedir}/ssm/
%{_libdir}/pkgconfig/%{name}.pc

%changelog
