# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		ssss
Summary:	Shamir's Secret Sharing Scheme
Version:	0.5
Release:	alt1_11
Source:		http://point-at-infinity.org/ssss/ssss-%{version}.tar.gz
Patch0:		ssss-0.5-cflags.patch
URL:		http://point-at-infinity.org/ssss/
Group:		File tools
License:	GPLv2+
BuildRequires:	xmltoman
BuildRequires:	libgmp-devel
Source44: import.info

%description
ssss is an implementation of Shamir's secret sharing scheme for UNIX/linux
machines.

Citing from the Wikipedia article about Secret Sharing:

    In cryptography, a secret sharing scheme is a method for distributing
    a secret amongst a group of participants, each of which is allocated
    a share of the secret. The secret can only be reconstructed when the
    shares are combined together; individual shares are of no use on their
    own.

    More formally, in a secret sharing scheme there is one dealer and n
    players. The dealer gives a secret to the players, but only when specific
    conditions are fulfilled. The dealer accomplishes this by giving each
    player a share in such a way that any group of t (for threshold) or
    more players can together reconstruct the secret but no group of less
    than t players can. Such a system is called a (t,n)-threshold scheme.

ssss does both: the generation of shares for a known secret and the
reconstruction of a secret using user provided shares.

%prep
%setup -q
%patch0 -p1


%build

%make_build

%install
install -d %{buildroot}%{_bindir}
install -d %{buildroot}%{_mandir}/man1
cp -p ssss-split ssss-combine %{buildroot}%{_bindir}
cp -p ssss.1 %{buildroot}%{_mandir}/man1

%files
%doc LICENSE HISTORY doc.html ssss.1.html THANKS
%{_bindir}/ssss-split
%{_bindir}/ssss-combine
%{_mandir}/man1/ssss.1*


%changelog
