# BEGIN SourceDeps(oneline):
BuildRequires: libbsd-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name starlink-pal
%define major        0
%define libname      lib%{name}%{major}
%define libname_virt lib%{name}
%define develname    lib%{name}-devel

Name:           starlink-pal
Version:        0.9.10
Release:        alt1_1
Summary:        Positional Astronomy Library
Group:          Sciences/Astronomy
License:        GPLv2+
URL:            https://github.com/Starlink/pal
Source0:        https://github.com/Starlink/pal/archive/v%{version}/pal-%{version}.tar.gz
Patch0:         starlink-pal-deb-rename_library.patch
Patch1:         starlink-pal-deb-use_std_automake.patch
Patch2:         Define-_DEFAULT_SOURCE-to-have-strlcpy-defined.patch

BuildRequires:  erfa-devel
BuildRequires:  texlive
BuildRequires:  texlive-dist
Source44: import.info

%description
The PAL library is a partial re-implementation of Pat Wallace's
popular SLALIB library written in C using a Gnu GPL license and
layered on top of the IAU's SOFA library where appropriate. PAL
attempts to stick to the SLA C API where possible although palObs()
has a more C-like API than the equivalent slaObs() function. In most
cases it is enough to simply change the function prefix of a routine
in order to link against PAL rather than SLALIB.

%package -n %{develname}
Summary:        Headers for developing programs that will use %{name}
Group:          Sciences/Astronomy
Requires:       %{libname_virt} = %{version}-%{release}
Provides:       %{name}-devel = %{version}-%{release}

%description -n %{develname}
These are the header files and libraries needed to develop a %{name} 
application.

%package -n %{libname}
Summary:        Positional Astronomy Library
Group:          Sciences/Astronomy
Provides:       %{name} = %{version}-%{release}
Provides:       %{libname_virt} = %{version}-%{release}

%description -n %{libname}
The PAL library is a partial re-implementation of Pat Wallace's
popular SLALIB library written in C using a Gnu GPL license and
layered on top of the IAU's SOFA library where appropriate. PAL
attempts to stick to the SLA C API where possible although palObs()
has a more C-like API than the equivalent slaObs() function. In most
cases it is enough to simply change the function prefix of a routine
in order to link against PAL rather than SLALIB.

%prep
%setup -q -n pal-%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1


%build
autoreconf -vfi
%configure --disable-static
%make_build

%install
%makeinstall_std

rm -f %{buildroot}%{_datadir}/pal/*.pdf

pushd %{buildroot}%{_libdir}
ln -s libstarlink_pal.so.0.0.0 libpal.so.0.0.0
ln -s libstarlink_pal.so.0.0 libpal.so.0.0
ln -s libstarlink_pal.so libpal.so
popd

rm -f %{buildroot}%{_datadir}/pal/{COPYING,README}*

%files -n %{libname}
%doc --no-dereference COPYING
%{_libdir}/lib*.so.%{major}
%{_libdir}/lib*.so.%{major}.*

%files -n %{develname}
%{_libdir}/*.so
%{_includedir}/*


%changelog
