%filter_from_requires /^python3.action./d
%filter_from_requires /^python3.ahttp./d
%filter_from_requires /^python3.channels./d
%filter_from_requires /^python3.compat2and3./d
%filter_from_requires /^python3.config./d
%filter_from_requires /^python3.logo./d
%filter_from_requires /^python3.uikit./d
Group: Sound
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: /usr/bin/desktop-file-install python3-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global __python %{__python3}
%global _name   streamtuner2

Name:           streamtuner
Version:        2.2.2
Release:        alt1_3
Summary:        An internet radio browser
License:        Public Domain
URL:            http://sourceforge.net/projects/streamtuner2/
Source0:        http://downloads.sf.net/streamtuner2/streamtuner2-%{version}.src.txz
BuildArch:      noarch

BuildRequires:  desktop-file-utils
BuildRequires:  fdupes

Requires:       gtk3-demo libgail3 libgtk+3 libgtk+3-gir libgtk+3-schemas
Requires:       python3
Requires:       python3-module-pygobject3 python3-module-pygobject3-pygtkcompat
Requires:       python3-module-lxml
Requires:       python3-module-Pillow
Requires:       python3-module-pyquery
Requires:       python3-module-simplejson
Requires:       python3-module-requests
Requires:       xterm
Requires:       audacious
# Needed for properties icons (channels & features)
Requires:       fonts-otf-gdouros-symbola

# required for youtube record
Requires:       python3-module-youtube_dl youtube-dl

# Patches
Patch0:         streamtuner2-default-config-desktop-file.patch
Source44: import.info

%description
Streamtuner lists radio directory services like Shoutcast, Xiph, Live365, 
MyOggRadio, Jamendo. It allows listening via any audio player and recording of
streams via streamripper.
This is streamtuner2 which mimics the older streamtuner 0.99.99 application
in look and feel. But it's an independent rewrite and runs on Python;
is therefore easier to extend.

%prep
%setup -qn %{_name}
%patch0 -p1 -b .default-config-desktop-file
# rpmlint
find . -type f -exec sed -i -e 's|\/usr\/bin\/env python|\/usr\/bin\/python3|g' {} \;

%build

%install
rm help/guiseq
# rpmlint
rm .zip.py

install -D -m 755 bin %{buildroot}/%{_bindir}/%{_name}
install -D -m 644 %{_name}.desktop %{buildroot}/%{_datadir}/applications/%{_name}.desktop
install -D -m 644 %{_name}.png %{buildroot}/%{_datadir}/pixmaps/%{_name}.png

mkdir %{buildroot}/%{_datadir}/%{_name}
install -m 644 gtk3.xml.gz %{buildroot}/%{_datadir}/%{_name}/
files=`find . -maxdepth 1 -type f -name "*.py" -or -name "*.png" -or -name "*.glade"`
for f in $files
    do install -m 644 $f %{buildroot}/%{_datadir}/%{_name}/
done

mkdir %{buildroot}/%{_datadir}/%{_name}/channels
pushd channels
files=`find . -maxdepth 1 -type f -name "*.py" -or -name "*.png"`
for f in $files
    do install -m 644 $f %{buildroot}/%{_datadir}/%{_name}/channels/
done
popd

mkdir -p %{buildroot}/%{_mandir}/man1
install -m 644 help/streamtuner2.1 %{buildroot}/%{_mandir}/man1/
rm help/streamtuner2.1

desktop-file-install                         \
  --dir %{buildroot}%{_datadir}/applications \
  --add-category Audio                       \
  --add-category Tuner                       \
  --add-category GTK                         \
  --delete-original                          \
  %{buildroot}%{_datadir}/applications/%{_name}.desktop

fdupes -s %{buildroot}


%files
%doc README CREDITS NEWS help/
%{_bindir}/%{_name}
%{_datadir}/applications/%{_name}.desktop
%{_datadir}/pixmaps/%{_name}.png
%{_datadir}/%{_name}/
%{_mandir}/man1/streamtuner2.1*

%changelog
