# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
BuildRequires: /usr/bin/jar /usr/bin/java /usr/bin/javac
# END SourceDeps(oneline)
BuildRequires: /proc java-devel-default
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           sudokuki
Version:        1.2.4
Release:        alt1_5
Summary:        Essential Sudoku game
Group:          Games/Puzzles
License:        GPLv3+
URL:            http://sudokuki.sourceforge.net
Source0:        https://downloads.sf.net/sudokuki/%{name}-%{version}.tar.bz2
Patch0:         sudokuki-1.2.4-mga-parallel-make.patch

BuildArch:	noarch
BuildRequires:  gettext-tools libasprintf-devel libtextstyle-devel
BuildRequires:  libtool
BuildRequires:  java-devel-default /proc
Source44: import.info

%description
Sudokuki is a free graphical SUDOKU game developed in Java.
You can use it to solve even the most difficult grids for you,
and also to generate a sudoku, edit it, play it or print it.

%prep
%setup -q
%patch0 -p1


%build
autoreconf -vfi
%configure --bindir=%{_gamesbindir} \
               --build=%{_build} \
               --datadir=%{_javadir}
%make_build

%install
%makeinstall_std

# Create an unversioned symbolic link according to Mageia's java policy
pushd %{buildroot}%{_javadir}/%{name}/
ln -sf %{name}-%{version}.jar %{name}.jar
popd

# Create the menu entry
cat > %{name}.desktop << EOF
[Desktop Entry]
Type=Application
Terminal=false
Name=Sudokuki
Name[fr]=Sudokuki
Comment=Essential Sudoku game
Comment[fr]=Jeu de Sudoku essentiel
Exec=%{name}
Icon=%{name}
Categories=Game;LogicGame;
EOF
install -D -m755 %{name}.desktop %{buildroot}%{_datadir}/applications/%{name}.desktop

# Install the icon
install -D -m644 src/resources/files/net/jankenpoi/sudokuki/resources/images/sudokuki_icon.png \
    %{buildroot}%{_datadir}/pixmaps/%{name}.png

%files
%doc AUTHORS README
%{_datadir}/applications/%{name}.desktop
%{_datadir}/pixmaps/%{name}.png
%{_gamesbindir}/%{name}
%{_javadir}/%{name}/%{name}*.jar


%changelog
