Group: Engineering
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name: swarp
Version: 2.38.0
Release: alt2_28
Summary: Tool that resamples and co-adds together FITS images

# Automatically converted from old format: GPLv3+ - review is highly recommended.
License: GPL-3.0-or-later
URL: http://www.astromatic.net/software/%{name}
Source: http://www.astromatic.net/download/swarp/swarp-%{version}.tar.gz
Patch: fix-gcc15.patch

# https://gcc.gnu.org/gcc-10/porting_to.html#common
# https://github.com/astromatic/sextractor/issues/12
%add_optflags -fcommon

BuildRequires: gcc
Source44: import.info

%description
SWarp is a program that resamples and co-adds together FITS images 
using any arbitrary astrometric projection defined in the WCS standard. 

%package doc
Group: Documentation
Summary: Documentation for %{name}
BuildArch: noarch

%description doc
This package contains the documentation for %{name}.

%prep
%setup -q
%patch0 -p1


%build
%configure --enable-threads
%make_build

%install
make DESTDIR=%{buildroot} install

%files
%doc AUTHORS BUGS COPYRIGHT HISTORY README THANKS TODO
%doc --no-dereference COPYRIGHT
%{_bindir}/*
%{_mandir}/man1/*
%{_mandir}/manx/*
%{_datadir}/%{name}/

%files doc
%doc doc/swarp.pdf 
%doc --no-dereference COPYRIGHT

%changelog
