Group: Sound
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install gcc-c++ glib2-devel
# END SourceDeps(oneline)
%define fedora 34
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           sweep
Version:        0.9.3
Release:        alt6_32
Summary:        An audio editor and live playback tool
License:        GPLv2+
URL:            http://www.metadecks.org/software/sweep/index.html

Source:         http://prdownloads.sourceforge.net/sweep/%{name}-%{version}.tar.gz
Patch0:         sweep-0.9.3-multithread.patch

BuildRequires:  gcc
BuildRequires:  desktop-file-utils
BuildRequires:  libogg-devel
BuildRequires:  libmad-devel
BuildRequires:  sed
BuildRequires:  libalsa-devel
BuildRequires:  gtk-builder-convert gtk-demo libgail-devel libgtk+2-devel
BuildRequires:  libsamplerate-devel
BuildRequires:  libsndfile-devel
BuildRequires:  libvorbis-devel
BuildRequires:  libspeex-devel
Requires(post):   desktop-file-utils
Requires(postun): desktop-file-utils
Source44: import.info

%description
Sweep is an audio editor and live playback tool for GNU/Linux, BSD and
compatible systems. It supports many music and voice formats including
WAV, AIFF, Ogg Vorbis, Speex and MP3, with multichannel editing and
LADSPA effects plugins.


%package devel
Group: Development/Other
Summary:        Development files for Sweep
Requires:       libgio
Requires:       gtk-builder-convert gtk-demo

%description devel
Header files and libraries for Sweep development.


%prep
%setup -q
%patch0 -p1 -b .multithread
# fix for wrongly set plugin dir on 64-bit
sed -i 's/sweep_plugin_dir=.*/sweep_plugin_dir="$PACKAGE_PLUGIN_DIR"/' configure


%build
LDFLAGS="-lX11 -lgmodule-2.0"
export LDFLAGS
%configure --disable-rpath
%make_build V=1


%install
make DESTDIR=$RPM_BUILD_ROOT install

# rename binary and manpage because of name conflict with lam package
(cd $RPM_BUILD_ROOT%{_bindir}; mv sweep sweep-audio-editor)
(cd $RPM_BUILD_ROOT%{_mandir}/man1; 
  mv sweep.1 sweep-audio-editor.1
  sed -i -e 's|.B sweep|.B sweep-audio-editor|' sweep-audio-editor.1
)

cat > sweep.desktop << EOF
[Desktop Entry]
Name=Sweep
GenericName=Sound Editor
Comment=Audio editor and live playback tool
Exec=sweep-audio-editor
Icon=sweep.svg
Terminal=false
Type=Application
MimeType=audio/x-wav;audio/x-aiff;audio/x-aifc;application/ogg;audio/x-mp3;audio/mpeg;audio/basic
Encoding=UTF-8
X-Desktop-File-Install-Version=0.9.4
StartupWMClass=Sweep
EOF

rm -f $RPM_BUILD_ROOT%{_datadir}/applications/sweep.desktop
desktop-file-install \
%if 0%{?fedora} && 0%{?fedora} < 19
        --vendor fedora \
%endif
        --add-category Application \
        --add-category AudioVideo \
        --add-category AudioVideoEditing \
        --dir $RPM_BUILD_ROOT%{_datadir}/applications \
        sweep.desktop

find $RPM_BUILD_ROOT%{_libdir}/sweep -name "*.la" | xargs rm -f
find $RPM_BUILD_ROOT%{_libdir}/sweep -name "*.a" | xargs rm -f

%find_lang %{name}

%files -f %{name}.lang
%{_bindir}/sweep*
%{_libdir}/sweep
%{_datadir}/pixmaps/sweep.svg
%{_datadir}/sweep
%{_datadir}/applications/*
%{_mandir}/man*/*
%doc AUTHORS ChangeLog COPYING NEWS README TODO doc/plugin_writers_guide.txt


%files devel
%doc doc/plugin_writers_guide.txt
%{_includedir}/sweep


%changelog
