%define fedora 21
Name:		sys_basher
Version:	2.0.2
Release:	alt2_2
Summary:	A multithreaded hardware exerciser

Group:		File tools
License:	BSD
URL:		http://www.polybus.com/sys_basher_web/
Source0:	http://www.polybus.com/sys_basher/%{name}-%{version}.tar.gz

BuildRequires:	tcsh
BuildRequires:	lm_sensors3-devel
BuildRequires:	help2man

Requires: lm_sensors3 dmidecode

ExcludeArch: ppc ppc64 armv3l armv4b armv4l armv4tl armv5tel armv5tejl armv6l armv7l armv7hl armv7hnl
Source44: import.info

%description
sys_basher is a multithreaded system exerciser. It tests the CPU, RAM and Disks
under conditions of maximum stress by running CPU, Memory and Disk tests on all
Cores simultaneously. In addition to reliablity testing, sys_basher measures
low level functions including memory bandwidth, disk IO bandwidth and integer
and floating point operations using unrolled loops.

%prep
%setup -q


%build
echo %{?dist}
echo %{?fedora}
echo %{?rhel}
echo 0%{?dist}
echo 0%{?fedora}
echo 0%{?rhel}
echo 1%{?dist}
echo 1%{?fedora}
echo 1%{?rhel}
%if  0%{?rhel} > 5 || 0%{?fedora} > 1
echo el6,7 or fedora
make %{?_smp_mflags} CFLAGS="$RPM_OPT_FLAGS"
%else %{rhel} > 5)
echo el5
make %{?_smp_mflags} CFLAGS="$RPM_OPT_FLAGS" sys_basher2
%endif

%install
%if 0%{?rhel} > 5 || 0%{?fedora} > 1
make install DESTDIR=$RPM_BUILD_ROOT BINDIR=%{_bindir} MANDIR=%{_mandir} INITDIR=%{_initrddir}
%else
make %{?_smp_mflags} CFLAGS="$RPM_OPT_FLAGS" sys_basher2
help2man -N ./sys_basher -o sys_basher.1
%{__install} -p -D -m 0755 sys_basher $RPM_BUILD_ROOT%{_bindir}/sys_basher
%{__install} -p -D -m 0755 sys_basher_setup $RPM_BUILD_ROOT%{_bindir}/sys_basher_setup
%{__install} -p -D -m 0755 sys_basher_disable_oom $RPM_BUILD_ROOT%{_bindir}/sys_basher_disable_oom
%{__install} -p -D -m 0755 sys_basher.init $RPM_BUILD_ROOT%{_initrddir}/sys_basher.init
%{__install} -p -D -m 644 sys_basher.1 $RPM_BUILD_ROOT%{_mandir}/man1/sys_basher.1
%endif

%post
/sbin/chkconfig --add sys_basher.init
#/etc/rc.d/init.d/sys_basher.init start

%files
%doc README COPYRIGHT
%{_bindir}/sys_basher
%{_bindir}/sys_basher_setup
%{_bindir}/sys_basher_disable_oom
%{_initrddir}/sys_basher.init
%{_mandir}/man1/sys_basher.1.*



%changelog
