# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define uname   Tanks-of-Freedom

Name:           tanks-of-freedom
Version:        0.7.0
Release:        alt1_4
Summary:        Indie turn-based strategy game in isometric pixel art
Group:          Games/Strategy
License:        MIT and CC BY-SA 4.0 and OFL
URL:            http://tof.p1x.in
Source0:        https://github.com/w84death/Tanks-of-Freedom/archive/%{version}-beta/%{uname}-%{version}-beta.tar.gz

BuildArch:      noarch
Requires:       godot-runner
Source44: import.info

%description
Classic turn-based strategy game with two armies fighting against each
other. Challenge yourself in campaign against AI or hot-seat battle
with a friend. Using easy map editor you can create any imaginable
scenario to play and share online for others to discover!

%prep
%setup -q -n %{uname}-%{version}-beta


cp -f buildConfig/engine_linux32.cfg engine.cfg

# Those files are not needed to play
rm -rf bin buildConfig .git{attributes,ignore}

%build

%install
install -d %{buildroot}%{_gamesdatadir}/%{name}
cp -a . %{buildroot}%{_gamesdatadir}/%{name}/

cat << EOF > %{name}.sh
#!/bin/sh
exec godot-runner -path %{_gamesdatadir}/%{name} "\$@"
EOF
install -D -m755 %{name}.sh %{buildroot}%{_gamesbindir}/%{name}

for size in 32 48 128 256 1024; do
  install -D -m644 assets/icons/icon${size}.png %{buildroot}%{_iconsdir}/hicolor/${size}x${size}/apps/%{name}.png
done

install -d %{buildroot}%{_datadir}/applications
cat << EOF > %{buildroot}%{_datadir}/applications/%{name}.desktop
[Desktop Entry]
Name=Tanks of Freedom
GenericName=Turn-based strategy game
Comment=Indie turn-based strategy game in isometric pixel art
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
Categories=Game;StrategyGame;
EOF

%files
%doc CHANGELOG.md LICENSE.md README.md
%{_gamesbindir}/%{name}
%{_gamesdatadir}/%{name}/
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/*/apps/%{name}.png


%changelog
