Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: /usr/bin/git libicu-devel perl(Term/ReadKey.pm) perl(UUID/Tiny.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define __cmake_in_source_build 1
Name:    termy-server
Summary: TermySequence terminal multiplexer server
Version: 1.1.4
Release: alt2_16

License: GPLv2
URL:     https://termysequence.io
Source:  https://termysequence.io/releases/termysequence-server-%{version}.tar.xz

Patch1: setup-fix-session-check.patch

BuildRequires: ctest cmake
BuildRequires: gcc-c++
BuildRequires: libcmocka-devel
BuildRequires: libgit2-devel >= 0.26
BuildRequires: libuuid-devel
BuildRequires: libsystemd-devel libudev-devel
BuildRequires: libutf8cpp-devel libutfcpp-devel

%{?systemd_requires}
Requires: libgit2
Obsoletes: termy-shell-integration-bash
Source44: import.info

%description
A multiplexing terminal emulator server implementing
the TermySequence protocol.

%prep
%setup -q -n termysequence-%{version}
%patch1 -p1

# Avoid the bundled copy of UTF8-CPP
rm -rf vendor/utf8cpp

%build
%{fedora_v2_cmake} -DCMAKE_BUILD_TYPE=Release -DBUILD_TESTS=ON .
%make_build

%install
%makeinstall_std

%check
ctest -V

%post
%systemd_user_post termy-server.socket

%preun
%systemd_user_preun termy-server.service termy-server.socket

%files
%doc --no-dereference COPYING.txt
%{_bindir}/termy*
%{_datadir}/termy-server
%{_userunitdir}/termy-server.*
%{_mandir}/man1/termy*.1*

%changelog
