Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: perl(JSON.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define autorelease 2

Name:    testssl
Version: 3.2~rc3
%global ver 3.2rc3
Release: alt1_%autorelease

Summary: Testing TLS/SSL encryption
License: GPL-2.0-only
URL:     https://testssl.sh/
Source0: https://github.com/drwetter/testssl.sh/archive/refs/tags/v%{ver}.tar.gz

BuildArch: noarch

BuildRequires: coreutils
BuildRequires: sed

Requires: bash sh
# dig, host, nslookup
Requires: bind bind-utils
# /etc/pki/tls
Requires: ca-trust
Requires: coreutils
Requires: gawk
# locale
Requires: glibc-core glibc-timezones glibc-utils iconv
Requires: grep
Requires: coreutils
# tput
Requires: termutils
Requires: openssl >= 1
# ps
Requires: libproc2 procps
Requires: sed
# hexdump, kill
Requires: cfdisk eject fdisk getopt hwclock look lsblk msulogin rfkill setarch sfdisk shadow-change util-linux
Source44: import.info

%description
testssl.sh is a free command line tool which checks a server's service on any
port for the support of TLS/SSL ciphers, protocols as well as recent
cryptographic flaws and more.

%prep
%setup -q -n %{name}.sh-%{ver}

sed --in-place '1s#^\#!/usr/bin/env bash$#\#!/bin/bash#' %{name}.sh etc/client-simulation.txt
sed --in-place 's#^TESTSSL_INSTALL_DIR=.*$#TESTSSL_INSTALL_DIR="%{_datadir}/%{name}"#' %{name}.sh
sed --in-place 's#^CA_BUNDLES_PATH=.*$#CA_BUNDLES_PATH="/etc/pki/tls"#' %{name}.sh
sed --in-place '0,/.SH "COPYRIGHT"/s#testssl\\.sh#testssl#g' doc/%{name}.1

%build

%install
install -D --preserve-timestamps %{name}.sh %{buildroot}%{_bindir}/%{name}

for file in ca_hashes.txt cipher-mapping.txt client-simulation.txt common-primes.txt tls_data.txt README.md
do
        install -D --preserve-timestamps --mode=0644 etc/${file} %{buildroot}%{_datadir}/%{name}/etc/${file}
done

install -d %{buildroot}%{_mandir}/man1
install -m 644 doc/%{name}.1 %{buildroot}%{_mandir}/man1/

%files
%doc CHANGELOG.md Readme.md
%doc --no-dereference LICENSE
%{_bindir}/*
%{_datadir}/%{name}
%{_mandir}/man1/testssl.1*

%changelog
