Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: /usr/bin/doxygen cmake openmpi-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global prerelease a3
Name:           tiny-dnn
Version:        1.0.0
Release:        alt2_0.%{prerelease}.3.9
Summary:        Header only, dependency-free deep learning framework in C++14

License:        BSD
URL:            https://github.com/tiny-dnn/tiny-dnn/
Source0:        https://github.com/tiny-dnn/tiny-dnn/archive/v%{version}%{prerelease}/%{name}-%{version}%{prerelease}.tar.gz
# Patch to optionally use system-wide installation of gtest/gmock.
# Upstream PR: https://github.com/tiny-dnn/tiny-dnn/pull/968/
Patch0:         %{name}.distro-gmock.patch
# Do not overwrite cflags.
# Will not be merged upstream, only makes sense downstream
Patch1:         %{name}.compile-flags.patch

# Test fails on ix86.
ExcludeArch:    %{ix86}

BuildRequires:  /usr/bin/ctest
BuildRequires:  gcc-c++
BuildRequires:  libgtest-devel
BuildRequires:  libgmock-devel
BuildRequires:  pkgconfig(tbb)
BuildRequires:  libprotobuf-devel
BuildRequires:  protobuf-compiler
Source44: import.info

%description
tiny-dnn is a C++14 implementation of deep learning. It is suitable for deep
learning on limited computational resource, embedded systems and IoT devices.


%package        devel
Group: Other
Summary:        Development files for %{name}
Provides:       tiny-dnn-static = %{version}-%{release}

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.


%global debug_package %{nil}

%prep
%setup -q -n %{name}-%{version}%{prerelease}
%patch0 -p1
%patch1 -p1



%build
# This fails at link time with LTO on armv7.  Disable LTO for now
%define _lto_cflags %{nil}
%{fedora_v2_cmake} -DBUILD_TESTS=ON -DUSE_SYS_GTEST=ON
%fedora_v2_cmake_build


%install
%fedora_v2_cmake_install


%check
%fedora_v2_ctest --timeout 15000

%files devel
%doc --no-dereference LICENSE
%doc README.md
%{_includedir}/tiny_dnn
%{_datadir}/TinyDNN


%changelog
