Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global project themanaworld
%global commit0 0fe3e2164dc75117af1f3c96aeb7599ba3495f71
%global date0   20151005

Name:           tmw-music
# we do not know any newer version, latest from obsolete Sourceforge is 0.3
Version:        0.3.0.1
Release:        alt2_0.10.%{date0}git%(c=%{commit0}; echo ${c:0:7})
Summary:        Music files for The Mana World

# generally license is GPLv2, most ogg files with CC-BY-SA,
# but CC0 for ride-of-the-valkyries.ogg (see music-license.md)
License:        GPLv2 and CC-BY-SA and CC0
URL:            https://www.%{project}.org
Source0:        https://github.com/%{project}/%{name}/archive/%{commit0}.tar.gz#/%{name}-%{commit0}.tar.gz
BuildArch:      noarch

# let people find us via project name
Provides:       %{project}-music

Obsoletes:      manaworld-music <= 0.3-4
Provides:       manaworld-music = %{version}-%{release}

Requires:       tmw
Source44: import.info

%description
This package contains the optional music files for The Mana World (TMW). 
TMW is an innovative, free and open source MMORPG.
Besides the official game server, this client can connect to multiple
community-grown servers, which provide varied environments and further
challenge. In TMW, the players solve quests, fight monsters, practice skills
and study magic. Social activities include parties, trading and limited PvP in
designated areas. While there are no limits to solo play, collaborative
behavior such as healing others, fighting together and banding up against
tougher monsters are rewarded in the game. The Mana World graphics have been
inspired by 2D pixel art at its prime of the late 1990s, when many RPG
classics, such as Secret of Mana for the Super Nintendo Entertainment System,
were released.


%prep
%setup -q -n %{name}-%{commit0}


%build
# nothing to build


%install
mkdir -p %{buildroot}%{_datadir}/tmw/data/music
cp -p *.ogg %{buildroot}%{_datadir}/tmw/data/music


%files
%doc --no-dereference COPYING music-license.md
%doc README.md
# just in case, we're not absolutely sure what folders are owned already
%dir %{_datadir}/tmw
%dir %{_datadir}/tmw/data
%dir %{_datadir}/tmw/data/music
%{_datadir}/tmw/data/music/*.ogg


%changelog
