Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/glib-gettextize /usr/bin/glib-mkenums /usr/bin/gtkdocize gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global tomoe_ver 0.6.0

Name:           tomoe-gtk
Version:        %{tomoe_ver}
Release:        alt3_47
Summary:        Gtk library for tomoe for Japanese and Chinese handwritten input

License:        LGPL-2.0-or-later
URL:            https://sourceforge.net/projects/tomoe/
Source0:        http://downloads.sourceforge.net/project/tomoe/%{name}/%{name}-%{version}/%{name}-%{version}.tar.gz
Patch0:         %{name}-0.6.0-rpath.patch
Patch1:         %{name}-0.6.0-cflags.patch

Requires:       tomoe >= %{tomoe_ver}
Obsoletes:      libtomoe-gtk < 0.6.0-4
Provides:       libtomoe-gtk = %{version}-%{release}
BuildRequires:  libtool
BuildRequires:  autoconf, automake
BuildRequires:  tomoe-devel >= %{tomoe_ver} gtk-builder-convert gtk-demo libgail-devel libgtk+2-devel
# does not currently build with gucharmap-2
#BuildRequires:  gucharmap-devel
BuildRequires:  libgnomeui-devel
BuildRequires:  gettext-tools
Source44: import.info

%description
Gtk library for tomoe Japanese handwritten input.
This package is used by scim-tomoe or uim-tomoe.


%package devel
Group: Development/Other
Summary:    Gtk library for tomoe Japanese handwritten input
Requires:   %{name} = %{version}-%{release}
Requires:   gtk-builder-convert gtk-demo
Obsoletes:  libtomoe-gtk-devel < 0.6.0-4
# added for F10
Provides:   libtomoe-gtk-devel = %{version}-%{release}


%description devel
The libtomoe-devel package includes the header files for libtomoe-gtk.
Install this if you want to develop programs which will use libtomoe-gtk.


%prep
%setup -q
%patch0  -p0 -b .rpath
%patch1  -p0 -b .cflags

%build
autoreconf -ivf
%configure --disable-static --without-gucharmap --disable-dependency-tracking \
  --disable-rpath --with-python=no
%make_build CFLAGS="$RPM_OPT_FLAGS" 
cd po
mkdir -p locale
for p in *.po;do
    loc=$(basename $p .po)
    mkdir -p locale/$loc/LC_MESSAGES
    msgfmt $p -o locale/$loc/LC_MESSAGES/%{name}.mo
done
cd ..

%install
make install DESTDIR=$RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/%{_datadir}
cp -R po/locale $RPM_BUILD_ROOT/%{_datadir}

rm $RPM_BUILD_ROOT%{_libdir}/*.la

%find_lang %{name}





%files -f %{name}.lang
%doc AUTHORS COPYING NEWS README TODO
%{_libdir}/lib%{name}.so.*
%{_datadir}/%{name}/

%files devel
%{_libdir}/pkgconfig/%{name}.pc
%{_libdir}/lib%{name}.so
%{_includedir}/tomoe/*
%{_datadir}/gtk-doc/html/lib%{name}/

%changelog
