# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# ***********************************************************************
# *                                                                     *
# *            Star Traders: A Game of Interstellar Trading             *
# *               Copyright (C) 1990-2024, John Zaitseff                *
# *                                                                     *
# ***********************************************************************

# Author: John Zaitseff <J.Zaitseff@zap.org.au>
# $Id: 22bfe1341f2c8b68ecc061d4ef8318bdbef4ef6b $

# This file is distributed under the same licence as Star Traders itself:
# the GNU General Public License, version 3 or later.

Name:		trader
Version:	7.20
Release:	alt1_1
Summary:	A simple game of interstellar trading
License:	GPL-3.0-or-later
Group:		Games/Strategy
Url:		https://www.zap.org.au/projects/trader/
Source0:	https://ftp.zap.org.au/pub/trader/unix/%{name}-%{version}.tar.xz
Source1:	https://ftp.zap.org.au/pub/trader/unix/trader-%{version}.tar.xz.sig

BuildRequires:	gettext gettext-tools
BuildRequires:	gperf
BuildRequires:	pkgconfig(ncursesw)

Provides:	bundled(gnulib)
Source44: import.info

%description
Star Traders is a simple game of interstellar trading, where the objective
is to create companies, buy and sell shares, borrow and repay money, in
order to become the wealthiest player (the winner).

%prep
%setup -q

%build
%configure --bindir=%{_gamesbindir}
%make_build

%install
%makeinstall_std

%find_lang %{name}

%files -f %{name}.lang
%doc NEWS README
%doc --no-dereference COPYING
%{_gamesbindir}/%{name}
%{_datadir}/applications/au.org.zap.%{name}.desktop
%{_iconsdir}/hicolor/*/apps/%{name}.*
%{_metainfodir}/au.org.zap.%{name}.metainfo.xml
%{_mandir}/man6/%{name}.6*


%changelog
