# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		trigger-rally
Version:	0.6.6.1
Release:	alt3_6
Summary:	3D rally racing game
Group:		Games/Other
License:	GPLv2+
Url:		https://trigger-rally.sourceforge.net/
Source0:	https://downloads.sourceforge.net/trigger-rally/%{name}-%{version}.tar.gz
# Manpage from Debian
Source1:	%{name}.6
Patch0:		trigger-rally-0.6.6.1-disable-strip.patch
Patch1:		trigger-rally-0.6.6.1-libs.patch

BuildRequires:	libphysfs-devel
BuildRequires:	pkgconfig(freealut)
BuildRequires:	pkgconfig(gl)
BuildRequires:	pkgconfig(glew)
BuildRequires:	pkgconfig(glu)
BuildRequires:	pkgconfig(openal)
BuildRequires:	pkgconfig(sdl2)
BuildRequires:	pkgconfig(SDL2_image)
BuildRequires:	pkgconfig(tinyxml2)
Requires:	%{name}-data >= %{version}
Source44: import.info

%description
Trigger is a fast-paced open source rally racing game.

%package data
Group: Games/Other
Summary:	Data files for the Trigger Rally game
BuildArch:	noarch

# Previously in a separate SRPM

%description data
Arch independent data files for the Trigger Rally game.

%prep
%setup -q
%patch0 -p1
%patch1 -p1


# Make sure we don't use embedded tinyxml
rm -rf src/TinyXML2
rm -rf src/include/tinyxml2.h

%build

%make_build -C src

%install
install -D -m755 bin/%{name} %{buildroot}%{_gamesbindir}/%{name}

install -d %{buildroot}%{_gamesdatadir}/%{name}
cp -a data/data.{md5,zip} %{buildroot}%{_gamesdatadir}/%{name}/

install -D -m644 bin/%{name}.config.defs %{buildroot}%{_sysconfdir}/%{name}.config.defs
ln -s %{_sysconfdir}/%{name}.config.defs %{buildroot}%{_gamesdatadir}/%{name}/%{name}.config.defs

for size in 16 22 24 32 36 48 64 72 96 128 192 256; do
  install -D -m644 data/icon/trigger-${size}.png %{buildroot}%{_iconsdir}/hicolor/${size}x${size}/apps/%{name}.png
done
install -D -m644 data/icon/%{name}-icons.svg %{buildroot}%{_iconsdir}/hicolor/scalable/apps/%{name}.svg

install -D -m644 %{_sourcedir}/%{name}.6 %{buildroot}%{_mandir}/man6/%{name}.6

install -d %{buildroot}%{_datadir}/applications
cat > %{buildroot}%{_datadir}/applications/%{name}.desktop << EOF
[Desktop Entry]
Name=Trigger Rally
GenericName=Racing game
GenericName[de_DE]=Autorennen
GenericName[fr_FR]=Jeu de course
GenericName[ro_RO]=Joc cu curse
Comment=3D rally racing game
Comment[de_DE]=3D Rally-Autorennen
Comment[fr_FR]=un jeu de rally en 3D
Comment[ro_RO]=Un joc în 3D cu curse de raliu
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
Categories=Game;SportsGame;
EOF

%files
%doc doc/DATA_AUTHORS.txt doc/README.txt doc/README-stereo.txt
%{_datadir}/applications/%{name}.desktop
%{_gamesbindir}/%{name}
%{_iconsdir}/hicolor/*/apps/%{name}.*
%{_mandir}/man6/%{name}.6*

%files data
%config(noreplace) %{_sysconfdir}/%{name}.config.defs
%{_gamesdatadir}/%{name}/


%changelog
