# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
%define fedora 19
Name:           trustyrc
Version:        0.1.4
Release:        alt1_8
Summary:        Fully modular IRC robot

Group:          Networking/WWW
License:        GPLv3+
URL:            http://nicoleau.fabien.free.fr/weblog/?pages/trustyRC
Source0:        http://nicoleau.fabien.free.fr/%{name}/%{name}-%{version}.tar.gz

%if 0%{?fedora} 
BuildRequires:  tinyxml-devel libcurl-devel
%else if 0%{?rhel}
BuildRequires:  curl-devel
%endif
Obsoletes:      %{name}-plugins <= 0.1.2
Obsoletes:      %{name}-plugins-extras <= 0.1.2
Provides:       %{name}-plugins = %{version}-%{release}
Provides:       %{name}-plugins-extras = %{version}-%{release}
Source44: import.info

%description
trustyRC is a fully modular IRC robot which includes all of the common
bot features (channel moderation, administration, account system, quotes)
and much more.  trustyRC is comprised of a kernel and a plugin loader
which loads features such as a log system, configuration parser,
networking, etc.  All plugins can communicate with others,
providing a highly flexible system.

A plugin can be loaded or unloaded while the bot is running,
so if a plugin needs to be updated, it can be unloaded,
rebuilt and reloaded.  During this, the bot does not need to be stopped.
Plugins are stored in shared libraries; a plugin's features are available
to the bot when the plugin is loaded and those features are removed
when the plugin is unloaded.

%prep
%setup -q
sed -i -e '175d' src/plugins/usersinfos.cpp

%build
CXXFLAGS="${CXXFLAGS:-%optflags}"
export CXXFLAGS
%if 0%{?fedora}
make %{?_smp_mflags} PREFIX=%{_prefix} PLUGINSDIR=%{_libdir}/%{name} HAVE_TINYXML=yes
%else if 0%{?rhel}
make %{?_smp_mflags} PREFIX=%{_prefix} PLUGINSDIR=%{_libdir}/%{name} HAVE_TINYXML=no
%endif


%install
%if 0%{?fedora}
make install DESTDIR=$RPM_BUILD_ROOT PREFIX=%{_prefix} PLUGINSDIR=%{_libdir}/%{name} HAVE_TINYXML=yes
%else if 0%{?rhel}
make install DESTDIR=$RPM_BUILD_ROOT PREFIX=%{_prefix} PLUGINSDIR=%{_libdir}/%{name} HAVE_TINYXML=no
%endif

%files
%doc CHANGELOG COPYING FEATURES README HOWTO.plugins 
%doc code_documentation %{name}.conf.sample
%{_libdir}/%{name}
%{_bindir}/%{name}

%changelog
