Group: System/Libraries
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           tse3
Version:        0.3.1
Release:        alt4_34
Summary:        MIDI Sequencer Engine
License:        GPL+
URL:            http://tse3.sourceforge.net/
Source:         http://downloads.sourceforge.net/tse3/%{name}-%{version}.tar.gz
# patch for archs where size_t != unsigned int
# Fixes tse3 on amd64 systems, possibly others.
# Adapted from ALT Linux
#Patch0:         tse3-0.2.7-size_t-64bit.patch
Patch0:         tse3-size_t-64bit.patch
# This one is to fix compilation issues with gcc 4.3
Patch1:         tse3-gcc43.patch
# Fix FTBFS
Patch2:         tse3-autoconf.patch
BuildRequires:  gcc-c++
BuildRequires:  libalsa-devel
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  libtool
Source44: import.info

%description
TSE3 is a powerful open source sequencer engine written in C++. It is a 
'sequencer engine' because it provides the actual driving force elements of a
sequencer but provides no form of user interface. Sequencer applications or 
multimedia presentation packages will incorporate the TSE3 libraries to 
provide a user with MIDI sequencing facilities.

%package devel
Group: System/Libraries
Summary:        Development packages for the TSE3 MIDI Sequencer Library
Requires:       %{name} == %{version}-%{release}

%description devel
TSE3 is a powerful open source sequencer engine written in C++. It is a 
'sequencer engine' because it provides the actual driving force elements of a
sequencer but provides no form of user interface. Sequencer applications or 
multimedia presentation packages will incorporate the TSE3 libraries to 
provide a user with MIDI sequencing facilities.

This package holds the development documentation, examples and header files 
for TSE3.

%prep
%setup -q
%patch0 -p2 -b .64bit
%patch1 -p2 -b .gcc43
%patch2 -p1 -b .autoconf

# Fix strange permissions issues
find . -name "*.cpp" -perm /111 -exec chmod 644 {} \;
find . -name "*.h" -perm /111 -exec chmod 644 {} \;

# Fix encoding issues
for i in demos/Demo.tse3 doc/History; do
    iconv -o $i.iso88591 -f iso88591 -t utf8 $i
    touch -r $i $i.iso88591
    mv -f $i.iso88591 $i
done


%build
# Need a newer configure script
autoreconf -fi

# OSS is being deprecated
%configure --with-alsa --with-mutex --with-doc-install --without-oss
# Parallel make not supported
make

%install
make install DESTDIR=%{buildroot} INSTALL="install -p" \
     docsdir=%{_docdir}/%{name}-devel-%{version}/HTML

# Sort out the development documentation. We don't want everything cluttered.

# These files belong to the devel documentation contentwise:
install -pm 0644 ChangeLog NEWS README THANKS TODO \
        %{buildroot}%{_docdir}/%{name}-devel-%{version}/

# Create a demos subdir and install all available demos in there:
install -d -m 0755 %{buildroot}%{_docdir}/%{name}-devel-%{version}/demos/
mv %{buildroot}%{_docdir}/%{name}-devel-%{version}/HTML/*.tse* \
    %{buildroot}%{_docdir}/%{name}-devel-%{version}/demos/
install -pm 0644 demos/*.ins demos/*.mid demos/*.tse* \
    %{buildroot}%{_docdir}/%{name}-devel-%{version}/demos/

# Provide the example source files in devel documentation:
make -C src/examples/ clean
cp -a src/examples/ %{buildroot}%{_docdir}/%{name}-devel-%{version}/

# Remove unneeded files:
rm -rf %{buildroot}%{_docdir}/%{name}-devel-%{version}/*/.deps \
       %{buildroot}%{_docdir}/%{name}-devel-%{version}/*/*/.deps

# Remove the library with the non-standard filename (this is a carbon copy
# of lib%{name}.so.x so we are not losing anything) and the .la file.
rm -rf %{buildroot}/%{_libdir}/lib%{name}-%{version}.so \
       %{buildroot}/%{_libdir}/*.la


%files
%doc AUTHORS
%doc --no-dereference COPYING 
%{_bindir}/*
%{_libdir}/libtse3.so.*
%{_mandir}/man1/*


%files devel
%doc %{_docdir}/%{name}-devel-%{version}
%{_includedir}/*
%{_mandir}/man3/*
%{_libdir}/libtse3.so

%changelog
