Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-install /usr/bin/gettext gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           tuxanci
Version:        0.21.0
Release:        alt2_15
Summary:        First Tux shooter multi-player network game
# LICENCE:      GPLv2 text
## unused
# data/font/DejaVuSans.ttf: Bitstream Vera and Public Domain
License:        GPL+
URL:            http://www.tuxanci.org/en/start
Source0:        http://download.tuxanci.org/tuxanci-0.21.0.tar.bz2
Source1:        tuxanci.desktop
Source2:        tuxanci.appdata.xml
Patch1:         0001-SDLmain-is-no-more.patch
Patch2:         0002-dlopen-is-used-outside-server-too.patch
Patch3:         0003-Unbreak-DLIB_INSTALL_DIR.patch
Patch4:         0004-Make-the-icon-square.patch
# Do not install LICENCE file twice, we already put into license directory
Patch5:         tuxanci-0.21.0-Do-not-install-LICENSE.patch
# Do not install bundled fonts
Patch6:         tuxanci-0.21.0-Unbundle-fonts.patch
BuildRequires:  ctest cmake
BuildRequires:  desktop-file-utils
BuildRequires:  gcc
BuildRequires:  ImageMagick-tools
# libappstream-glib for appstream-util
BuildRequires:  libappstream-glib
BuildRequires:  libSDL-devel
BuildRequires:  libSDL_image-devel
BuildRequires:  libSDL_mixer-devel
BuildRequires:  libSDL_ttf-devel
BuildRequires:  zziplib-devel
Requires:       font(dejavusans)
Source44: import.info

%description
Tuxanci is a first Tux shooter game supporting single player and multi-player
modes both on a single computer and over the network.

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1


%build
%{fedora_v2_cmake} -DCMAKE_INSTALL_LIBDIR=%{_libdir} \
    -DCMAKE_FONT=%{_datadir}/fonts/dejavu-sans-fonts/DejaVuSans.ttf
%fedora_v2_cmake_build

%install
%fedora_v2_cmake_install

# Install icon
mkdir -p %{buildroot}%{_datadir}/icons/hicolor/{scalable,48x48}/apps
install -pm644 data/tuxanci.svg %{buildroot}%{_datadir}/icons/hicolor/scalable/apps/
convert -geometry 48x48 -depth 8 -background none data/tuxanci.svg \
    %{buildroot}%{_datadir}/icons/hicolor/48x48/apps/tuxanci.png

# Launcher
ln -s tuxanci-%{version} %{buildroot}%{_bindir}/tuxanci
desktop-file-install --dir=%{buildroot}%{_datadir}/applications %{SOURCE1}

# Appdata
mkdir -p %{buildroot}%{_datadir}/appdata/
install -pm644 %{SOURCE2} %{buildroot}%{_datadir}/appdata/
appstream-util validate-relax --nonet \
        %{buildroot}%{_datadir}/appdata/tuxanci.appdata.xml

%files
%doc --no-dereference LICENCE
#doc %{_docdir}/tuxanci-%{version}
%{_bindir}/tuxanci
%{_bindir}/tuxanci-%{version}
%{_libdir}/tuxanci-%{version}
%{_datadir}/tuxanci-%{version}
%_iconsdir/hicolor/*/*/*
%{_datadir}/applications/tuxanci.desktop
%{_datadir}/appdata/tuxanci.appdata.xml

%changelog
