Group: Text tools
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install /usr/bin/xmllint pkgconfig(ORBit-2.0) pkgconfig(bonobo-activation-2.0) pkgconfig(gtk+-2.0) pkgconfig(libbonobo-2.0) pkgconfig(libbonoboui-2.0)
# END SourceDeps(oneline)
BuildRequires: chrpath
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global with_mate 0

Name:           verbiste
Version:        0.1.49
Release:        alt1_3
Summary:        French conjugation system
License:        GPL-2.0-or-later
URL:            http://sarrazip.com/dev/verbiste.html
Source:         http://perso.b2b2c.ca/~sarrazip/dev/%{name}-%{version}.tar.gz
BuildRequires:  gcc
BuildRequires:  gcc-c++
BuildRequires:  desktop-file-utils
BuildRequires:  gettext-tools
BuildRequires:  libgnomeui-devel
BuildRequires:  libxml2-devel
BuildRequires:  libtool
BuildRequires:  automake
%if 0%{?with_mate}
BuildRequires:  mate-panel-devel
%endif
BuildRequires:  perl(XML/Parser.pm)
Source44: import.info

%description
This package contains a database of French conjugation templates
and a list of more than 7000 regular and irregular French verbs
with their corresponding template. It also comes with two command-line 
tools named french-conjugator and french-deconjugator.

%package        devel
Group: Development/C
Summary:        Development files for %{name}
Requires:       %{name} = %{version}-%{release}

%description    devel
This package contains libraries and header files for
developing applications that use %{name}.

%package        gnome
Group: Text tools
Summary:        GNOME Panel applet for Verbiste
Requires:       %{name} = %{version}-%{release}
Requires:       icon-theme-hicolor

%description    gnome
GNOME Panel applet and application based on Verbiste.

%if 0%{?with_mate}
%package        mate
Group: Text tools
Summary:        MATE Desktop Panel applet for Verbiste
Requires:       %{name} = %{version}-%{release}

%description    mate
MATE Desktop Panel applet and application based on Verbiste.
%endif

%prep
%setup -q
# convert doc files to unicode
for DOCFILE in README NEWS HACKING LISEZMOI; do
    iconv -f ISO8859-15 -t UTF8 < $DOCFILE > $DOCFILE.tmp
    mv -f $DOCFILE.tmp $DOCFILE
done

%build
autoreconf -ivf
%configure \
%if 0%{?with_mate}
           --with-mate-applet \
%endif
           --with-gnome-app \
           --disable-maintainer-mode \
           --without-examples \
           --disable-rpath
%make_build

%install
%makeinstall_std

find %{buildroot} -name '*.la' -delete -print

# This file gets created on x86_64 for no apparent reason.
# It's owned by glibc-common.
#rm -f %%{buildroot}%%{_datadir}/locale/locale.alias
desktop-file-install \
  --delete-original                          \
  --dir %{buildroot}%{_datadir}/applications \
  %{buildroot}%{_datadir}/applications/%{name}.desktop

rm -frv %{buildroot}%{_docdir}

%find_lang %{name} --with-man
%find_lang french-conjugator --with-man
%find_lang french-deconjugator --with-man


# multiple -f flags in %files for gnome: merging -f french-conjugator.lang into -f %{name}.lang
cat french-conjugator.lang >> %{name}.lang
# multiple -f flags in %files for gnome: merging -f french-deconjugator.lang into -f %{name}.lang
cat french-deconjugator.lang >> %{name}.lang
# kill rpath
for i in `find %buildroot{%_bindir,%_libdir,/usr/libexec,/usr/lib,/usr/sbin} -type f -perm -111 ! -name '*.la' `; do
	chrpath -d $i ||:
done

%files
%doc AUTHORS COPYING HACKING LISEZMOI NEWS README THANKS
%{_bindir}/french-*
%{_datadir}/verbiste*
%{_libdir}/*.so.*
%{_mandir}/man1/french-*.1*

%files devel
%{_includedir}/verbiste-0.1/
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files gnome -f %{name}.lang  
%{_bindir}/verbiste
%{_bindir}/verbiste-gtk
%{_datadir}/applications/*
%{_datadir}/icons/hicolor/*/apps/%{name}.*
%{_datadir}/texmf/tex/latex/verbiste
%{_mandir}/man3/verbiste.3*

%changelog
