Group: Engineering
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           vhybridize
Version:        0.5.9
Release:        alt1_22
Summary:        Virtual Hybridization command line tools

License:        GPLv3+
URL:            http://ygingras.net/bioinfo
Source0:        http://ygingras.net/files/%{name}-%{version}.tar.gz
BuildArch:      noarch

BuildRequires:  python-devel
BuildRequires:  python-module-pkg_resources python-module-setuptools
Source44: import.info

%description
Virtual Hybridization uses sets of short probes to generate datasets
for comparative genomics: given a DNA sequence and a set of probes,
the typical output will give a sequence of oriented probe hits along
the DNA sequence. Other tools are supplied to allow simple manipulations
such as format conversion and extraction of permutations.

%prep
%setup -q

%build
%{__python} setup.py build

%install
%{__python} setup.py install --skip-build --root %{buildroot}
# Remove shebang
for file in \
    %{buildroot}%{python_sitelibdir_noarch}/%{name}/scripts/{to_permutation.py,split_multi_fasta.py} \
    %{buildroot}%{python_sitelibdir_noarch}/%{name}/{utils.py,locate.py}   \
    %{buildroot}%{python_sitelibdir_noarch}/%{name}/scripts/{to_vhx.py,merge.py,filter.py}; do
    sed -i -e '/^#!\//, 1d' $file
done

%files
%doc AUTHORS.txt COPYING.txt README.txt TODO.txt docs/ examples/
%{_bindir}/vhy*
%{python_sitelibdir_noarch}/%{name}/
%{python_sitelibdir_noarch}/%{name}*.egg-info

%changelog
