# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/pod2man
# END SourceDeps(oneline)
Name:           vios-proxy
Version:        0.2
Release:        alt1_11
Summary:        Network proxy between a QEMU host and QEMU guests using virtioserial channels

Group:          System/Servers
License:        ASL 2.0
URL:            http://git.fedorahosted.org/git/?p=vios-proxy.git
Source0:        http://fedorahosted.org/released/vios-proxy/%{name}-%{version}.tar.gz
Patch0:         unistd.patch

BuildRequires: boost-devel boost-devel-headers boost-filesystem-devel boost-wave-devel boost-graph-parallel-devel boost-math-devel boost-mpi-devel boost-program_options-devel boost-signals-devel boost-intrusive-devel boost-asio-devel
BuildRequires:  gcc-c++
BuildRequires: ctest cmake
Source44: import.info

%description
The vios-proxy program suite creates a network tunnel between
a server in the QEMU host and a client in a QEMU guest.
The proxy server and client programs open normal TCP network
ports on localhost and the vios-proxy tunnel connects them using
QEMU virtioserial channels.

%package host

Summary:        Network proxy using virtioserial for QEMU host
Group:          System/Servers

%description host
The vios-proxy-host daemon runs on a QEMU host. A vios-proxy-host daemon
manages all the proxy connections for a single proxy service on the host.
Multiple vios-proxy-host daemons are required to provide proxy access to
multiple services on the host. A single vios-proxy-host daemon may open
multiple proxy channels to multiple QEMU guests limited only by the
number of virtioserial connections available to each guest.

%package guest

Summary:        Network proxy using virtioserial for QEMU guest
Group:          System/Servers

%description guest
The vios-proxy-guest daemon runs on a QEMU client. A vios-proxy-guest daemon
creates a listening network socket on the guest's localhost interface. When
client programs connect to this socket then the vios-proxy-guest daemon opens
a proxy channel to the host through the tunnel.

%package doc

Summary:        Documentation for vios-proxy
Group:          System/Servers

%description doc
The vios-proxy program suite creates a network tunnel between
a server in the QEMU host and a client in a QEMU guest.
The proxy server and client programs open normal TCP network
ports on localhost and the vios-proxy tunnel connects them using
QEMU virtioserial channels.

%prep
%setup -q
%patch0 -p1
pushd src
cmake -D CMAKE_INSTALL_PREFIX:STRING="%{_prefix}" -D CMAKE_CXX_FLAGS:STRING="%{optflags}" .
popd

%build
pushd src
make %{?_smp_mflags}
popd

%install
pushd src
make install DESTDIR=$RPM_BUILD_ROOT
popd

%files doc
%doc README.txt LICENSE NOTICE
%doc doc/

%files host
%{_bindir}/vios-proxy-host
%doc %{_mandir}/man1/vios-proxy-host.1.gz

%files guest
%{_bindir}/vios-proxy-guest
%doc %{_mandir}/man1/vios-proxy-guest.1.gz

%changelog
