# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:	Atari Jaguar Emulator
Name:		virtualjaguar
Version:	2.1.3
Release:	alt1_9
Group:		Emulators
License:	GPLv3
URL:		https://www.icculus.org/virtualjaguar/
Source0:	https://www.icculus.org/virtualjaguar/tarballs/%{name}-%{version}.tar.bz2
Patch0:		virtualjaguar-2.1.3-optflags.patch
Patch1:		virtualjaguar-2.1.3-missing-include.patch
BuildRequires:	pkgconfig(sdl)
BuildRequires:	pkgconfig(zlib)
BuildRequires:	pkgconfig(gl)
BuildRequires:	pkgconfig(libcdio)
BuildRequires:	pkgconfig(Qt5Core)
BuildRequires:	pkgconfig(Qt5Gui)
BuildRequires:	pkgconfig(Qt5OpenGL)
BuildRequires:	pkgconfig(Qt5Widgets)
Source44: import.info

%description
Virtual Jaguar is software dedicated to emulating the Atari Jaguar hardware on
a standard PC. The software was originally developed by David Raingeard of
Potato Emulation and was released under the GPL on 25 June 2003.

Virtual Jaguar GCC/Qt is not just a port of the MS Visual C++/SDL source code
but has also been extended and rewritten so that we can enjoy Atari Jaguar
emulation on every platform that has a GCC compiler and a port of Qt.

%prep
%setup -q -n linux-%{version}
%patch0 -p1
%patch1 -p1


# Fix Qt5 qmake call
sed -i 's|qmake -qt=5|%{_qt5_bindir}/qmake|' Makefile

%build
#Since 2.0.2, build breaks when using %%make macro because of -j2 parameter
#so we use make directly for now
make

%install

mkdir -p %{buildroot}%{_bindir}
install -m 755 %{name} %{buildroot}%{_bindir}/%{name}

mkdir -p %{buildroot}%{_datadir}/pixmaps
install -m 644 res/vj.xpm %{buildroot}%{_datadir}/pixmaps/%{name}.xpm

mkdir -p %{buildroot}%{_datadir}/applications
cat > %{buildroot}%{_datadir}/applications/%{name}.desktop << EOF
[Desktop Entry]
Name=Virtual Jaguar
Comment=Emulate the Atari Jaguar console
Comment[fr]=Émuler la console Atari Jaguar
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
StartupNotify=true
Categories=Game;Emulator;
Keywords=Emulator;Atari;Console;
EOF

%files
%doc docs/*
%{_bindir}/%{name}
%{_datadir}/pixmaps/%{name}.xpm
%{_datadir}/applications/%{name}.desktop


%changelog
