Group: System/Libraries
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		voms-mysql-plugin
Version:	3.1.7
Release:	alt2_25
Summary:	VOMS server plugin for MySQL

License:	Apache-2.0
URL:		https://italiangrid.github.io/voms/
Source:		https://github.com/italiangrid/%{name}/archive/v%{version}.tar.gz

Provides:	voms-mysql = %{version}-%{release}
Obsoletes:	voms-mysql < 3.1.6
Requires:	voms-server

BuildRequires:	gcc-c++
BuildRequires:	libtool
%if %{?fedora}%{!?fedora:0} >= 28 || %{?rhel}%{!?rhel:0} >= 8
BuildRequires:	libmariadb-devel
%else
BuildRequires:	libmysqlclient21-devel
%endif
BuildRequires:	libssl-devel
Source44: import.info

%description
The Virtual Organization Membership Service (VOMS) is an attribute authority
which serves as central repository for VO user authorization information,
providing support for sorting users into group hierarchies, keeping track of
their roles and other attributes in order to issue trusted attribute
certificates and SAML assertions used in the Grid environment for
authorization purposes.

This package offers the MySQL implementation for the VOMS server.

%prep
%setup -q
./autogen.sh

%build
%configure --libdir=%{_libdir}/voms --disable-static
%make_build

%install
%makeinstall_std
rm %{buildroot}%{_libdir}/voms/libvomsmysql.la

%files
%{_datadir}/voms/voms-mysql.data
%{_datadir}/voms/voms-mysql-compat.data
%dir %{_libdir}/voms
%{_libdir}/voms/libvomsmysql.so

%changelog
