# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Bio/SeqIO.pm) perl(DynaLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define oname   wise
%define rel	10

Name:		wise2
Version:	2.4.1
Release:	alt1_%{rel}
Summary:	Comparisons of DNA and protein sequences
Group:		Sciences/Biology
License:	GPL
URL:		https://www.ebi.ac.uk/~birney/wise2
Source:		https://www.ebi.ac.uk/~birney/wise2/%{oname}%{version}.tar.gz
Patch0:		fix_getline.patch
Patch1:		wise2.4.1-replace-isnumber.patch
Patch2:		wise2.4.1-fix-makefile.patch
Patch3:		wise2.4.1-clean-makefile.patch
BuildRequires:	glib2-devel libgio-devel
BuildRequires:	flex
Obsoletes:	wise = 2.4.1-3.mga5
Source44: import.info
Patch33: wise2.4.1-alt-as-needed.patch

%description
Wise2 is a package focused on comparisons of biopolymers, commonly DNA and 
protein sequence. Wise2's particular forte is the comparison of DNA sequence 
at the level of its protein translation. This comparison allows the
simultaneous prediction of say gene structure with homology based alignment.

The Wise2 package was principally written by Ewan Birney, who wrote the main
genewise and estwise programs. The protein comparison database search program
was written by Richard Copley using the underlying Wise2 libraries.
Wise2 also uses code from Sean Eddy for reading HMMs and
for Extreme value distribution fitting.

%prep
%setup -q -n %{oname}%{version}
%patch0
%patch1
%patch2
%patch3
%patch33 -p1


%build
cd src
%make_build all || :
cd ../src/dyc/
%make_build newdyc || :
export PATH="$PATH:$PWD"
%make_build linux
cd ../../src
export WISECONFIGDIR="$PWD/../wisecfg"
%make_build init
%make_build CFLAGS="-c $RPM_OPT_FLAGS `pkg-config --libs glib-2.0 --cflags glib-2.0`" all

%install

install -d -m 755 %{buildroot}%{_bindir}
install -m 755 src/models/{pswdb,psw,genewisedb,estwisedb,estwise,genewise,dba,dnal,genomewise} %{buildroot}%{_bindir}

install -d -m 755 %{buildroot}%{_datadir}/%{oname}
install -m 644 wisecfg/* %{buildroot}%{_datadir}/%{oname}

# configuration
install -d -m 755 %{buildroot}%{_sysconfdir}/profile.d
echo "export WISECONFIGDIR=%{_datadir}/%{oname}" > %{buildroot}%{_sysconfdir}/profile.d/%{oname}.sh
echo "setenv WISECONFIGDIR %{_datadir}/%{oname}" > %{buildroot}%{_sysconfdir}/profile.d/%{oname}.csh

%files
%doc README LICENSE docs
%{_bindir}/*
%{_datadir}/%{oname}
%config(noreplace) %{_sysconfdir}/profile.d/*


%changelog
