# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           wizznic
Version:        1.1
Release:        alt1_1
Summary:        Brick-matching puzzle game
Group:          Games/Puzzles
License:        GPLv3+
# http://wizznic.org/
URL:            https://dustedgames.blogspot.com/p/wizznic.html
Source0:        https://github.com/DusteDdk/Wizznic/archive/%{version}/%{name}-%{version}.tar.gz
Patch0:         wizznic-1.0-mga-compile-flags.patch

BuildRequires:  pkgconfig(sdl)
BuildRequires:  pkgconfig(SDL_image)
BuildRequires:  pkgconfig(SDL_mixer)
Requires:       %{name}-data >= %{version}
Source44: import.info

%description
Wizznic is a brick-matching puzzle-game, an improved version of Puzznic.
The challenge is to clear each level of bricks by moving the bricks next
to each other, this sounds a lot easier than it is. The bricks are heavy,
so you can only push them, not lift them up.

%files
%doc doc/changelog.txt doc/credits.txt doc/media-licenses.txt doc/music-score-credits.txt doc/readme.txt
%{_datadir}/applications/%{name}.desktop
%{_gamesbindir}/%{name}
%{_iconsdir}/hicolor/32x32/apps/%{name}.png
%{_mandir}/man6/%{name}.6*

#----------------------------------------------------------------------

%package data
Group: Games/Puzzles
Summary:        Arch-independent data files for the Wizznic game
BuildArch:      noarch

%description data
This package contains arch-independent data files for Wizznic,
a brick-matching puzzle game.

%files data
%{_gamesdatadir}/%{name}/

#----------------------------------------------------------------------

%prep
%setup -q -n Wizznic-%{version}
%patch0 -p1


%build

%make_build -f Makefile.linux \
    BINDIR=%{_gamesbindir} \
    DATADIR=%{_gamesdatadir}/%{name}/ \
    STRIP=:

%install
%makeinstall_std -f Makefile.linux \
    BINDIR=%{_gamesbindir} \
    DATADIR=%{_gamesdatadir}/%{name}/

install -d %{buildroot}%{_datadir}/applications
cat << EOF > %{buildroot}%{_datadir}/applications/%{name}.desktop
[Desktop Entry]
Name=Wizznic
Comment=Brick-matching puzzle game
GenericName=Puzzle game
Exec=%{name}
Icon=%{name}
Type=Application
Categories=Game;LogicGame;
EOF

install -D -m644 data/wmicon.png %{buildroot}%{_iconsdir}/hicolor/32x32/apps/%{name}.png


%changelog
