# BEGIN SourceDeps(oneline):
BuildRequires: perl(ctime.pl)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define         srcname       wmGrabImage
%add_optflags -fcommon

Name:           wmgrabimage
Version:        0.72
Release:        alt1_13
Summary:        A dockapp that maintains a thumbnail copy of any remote image
License:        GPLv2
Group:          Monitoring

URL:            http://dockapps.windowmaker.org/file.php/id/12
Source0:        http://dockapps.windowmaker.org/download.php/id/19/%{srcname}-%{version}.tgz

#fix old style call to convert with -geom instead of expected -geometry
Patch0:          %{srcname}-0.72-convert.patch
Patch1:          %{srcname}-0.72-ctime.patch
Patch2:          wmgrabimage-0.72-cflags.patch


BuildRequires:  glibc-devel glibc-devel-static
BuildRequires:  pkgconfig(xpm)
BuildRequires:  pkgconfig(x11)
BuildRequires:  pkgconfig(xext)

Requires: perl
Requires: ImageMagick-tools
Requires: wget
Requires: sed
Source44: import.info



%description
Wmgrabimage is another dockapp for WindowMaker, or any window manager
and desktop environment that handles dock applications. It displays a
small copy of any remote image you want to monitor via the "-url"
command line argument. The default update interval is 5 minutes but
can be overridden through the "-delay" option.



%prep
%setup -q -n %{srcname}-%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1



%build
export CFLAGS="${CFLAGS:-%optflags}";
export CXXFLAGS="${CXXFLAGS:-%optflags}";
cd %{srcname}

%make_build clean
%make_build


%install
cd %{srcname}
install -D -m 755 GrabImage %{buildroot}%{_bindir}/GrabImage
install -D -m 755 %{srcname} %{buildroot}%{_bindir}/%{name}
install -D -m 644 %{srcname}.1 %{buildroot}%{_mandir}/man1/%{name}.1


%files
%doc BUGS CHANGES COPYING HINTS TODO
%{_bindir}/GrabImage
%{_bindir}/%{name}
%{_mandir}/man1/%{name}.1*


%changelog
