Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           wordgrinder
Version:        0.8
Release:        alt1_12
Summary:        A command line word processor

License:        MIT
URL:            http://cowlark.com/wordgrinder
%global pkgid   %{name}-%{version}
Source:         https://github.com/davidgiven/%{name}/archive/%{name}-%{version}.tar.gz

BuildRequires:  gcc libncurses++-devel libncurses++w-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel ninja-build python3-module-ninja_syntax
BuildRequires:  lua-devel liblua5.4 lua5.4 lua5.4-module-luafilesystem
BuildRequires:  zlib-devel libXft-devel
BuildRequires:  libminizip-ng-compat-devel
Requires:       libncurses6 libncursesw6 libtic6 libtinfo6 lua5.4-module-luafilesystem
Source44: import.info

%description
WordGrinder is a Unicode-aware character cell word processor that runs in a
terminal (or a Windows console). It is designed to get the hell out of your way
and let you get some work done.

WordGrinder is a word processor for processing words. It is not WYSIWYG. It is
not point and click. It is not a desktop publisher. It is not a text editor. It
does not do fonts and it barely does styles. What it does do is words. It's
designed for writing text. It gets out of your way and lets you type

%package x11
Group: Other
Summary: X11 version of WordGrinder
Requires: %name = %version-%release
Requires: libX11
%description x11
An X11 version of the WordGrinder word processor.

%prep

%setup -q -n %{name}-%{version}

###############################################################################
%build

PREFIX=$RPM_BUILD_ROOT/%{_prefix} OBJDIR=$RPM_BUILD_ROOT/tmp WANT_STRIPPED_BINARIES=no make %{?_smp_mflags}

###############################################################################
%install

make install PREFIX=$RPM_BUILD_ROOT/%{_prefix}
install -D -m 0644 %{_builddir}/%{name}-%{version}/extras/wordgrinder.desktop %{buildroot}%{_datadir}/applications/wordgrinder.desktop

###############################################################################
%files
%doc --no-dereference licenses/COPYING.WordGrinder
%_bindir/wordgrinder
%_docdir/wordgrinder/README.wg
%_mandir/man1/wordgrinder.1*

%files x11
%doc --no-dereference licenses/COPYING.WordGrinder
%_bindir/xwordgrinder
%_mandir/man1/xwordgrinder.1*
%{_datadir}/applications/wordgrinder.desktop
%{_datadir}/pixmaps/wordgrinder.png
%{_datadir}/mime-info/wordgrinder.mime

###############################################################################
%changelog
