Group: Editors
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-alternatives rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-install /usr/bin/esd-config Canna-devel TestU01-devel dante fontconfig-devel gcc-c++ libX11-devel libXaw-devel libXext-devel libXmu-devel libXrender-devel libXt-devel libaudio-devel libcrypt-devel libdb4-devel libelf-devel libgnutls-devel libltdl7-devel libopenmotif-devel libtinfo-devel mpir-devel postgresql-devel texinfo xorg-cf-files xorg-proto-devel
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# The garbage collector does not work with PIE
%undefine _hardened_build

# TODO: review desktop entry associations (does text/* work?)
# TODO: zero-length /usr/share/xemacs-21.5-b26/lisp/dump-paths.el
# TODO: non-ASCII in buffer tabs

%bcond_with     gtk
%bcond_with     wnn
%bcond_with     xaw3d
%bcond_with     xfs
%bcond_with     xim
%bcond_without  mule
%bcond_without  nox
%ifarch ia64
# no-expdyn-ia64 patch, https://bugzilla.redhat.com/show_bug.cgi?id=106744#c39
%bcond_with     modules
%else
%bcond_without  modules
%endif

%global snap    20200331hge2ac728aa576

Name:           xemacs
Version:        21.5.34
Release:        alt2_42%{?snap:.%{snap}}
Summary:        Different version of Emacs

%global majver %(cut -d. -f1-2 <<<%{version})

License:        GPLv3+
URL:            http://www.xemacs.org/
%if 0%{?snap:1}
Source0:        %{name}-%{snap}.tar.xz
%else
Source0:        http://ftp.xemacs.org/xemacs-%{majver}/xemacs-%{version}.tar.gz
%endif
Source1:        %{name}.appdata.xml
Source2:        xemacs.desktop
Source3:        dotxemacs-init.el
Source4:        default.el
Source5:        xemacs-sitestart.el
Source6:        gnuclient.desktop

# Fedora-specific.  Don't run the check-features Makefile target.  It checks
# that necessary packages are installed, but they aren't installed while
# building an RPM.
Patch0:         %{name}-21.5.25-mk-nochk-features.patch
# Experimental patch.  Fix WNN support.  This patch is no longer sufficient.
# WNN still doesn't work.
Patch1:         %{name}-21.5.25-wnnfix-128362.patch
# Fedora-specific.  Don't force ISO-8859 fonts.
Patch2:         %{name}-21.5.34-utf8-fonts.patch
# Experimental patch, to be sent upstream eventually.  Don't use
# -export-dynamic on IA64; leads to segfaults due to function pointer issues.
Patch3:         %{name}-21.5.27-no-expdyn-ia64-106744.patch
# Fedora-specific.  Default to courier instead of lucidatypewriter.
Patch4:         %{name}-21.5.28-courier-default.patch
# Fedora-specific.  Recognize the Fedora X server.
Patch5:         %{name}-21.5.29-x-server.patch
# Submitted upstream by Henry Thompson: fix playing sounds through ALSA
Patch6:         %{name}-21.5.34-alsaplay.patch
# Submitted upstream 28 Dec 2017: do not rely on integer overflow wrapping
Patch7:         %{name}-21.5.34-overflow.patch
# Submitted upstream 28 Dec 2017: better computation of data start address
Patch8:         %{name}-21.5.34-data-start.patch
# Submitted upstream 22 Jul 2020: Use strsignal() in preference to sys_siglist
Patch9:         %{name}-21.5.34-strsignal.patch
# Do not protect -specs=* with -Xlinker
Patch10:        %{name}-21.5.34-xlinker.patch

BuildRequires:  libcompface-devel
BuildRequires:  desktop-file-utils
%if %{with mule}
%if %{with wnn}
BuildRequires:  FreeWnn-devel
%endif
%endif
BuildRequires:  gcc
BuildRequires:  libgdbm-devel
BuildRequires:  libgif-devel
BuildRequires:  libgmp-devel libgmpxx-devel
BuildRequires:  libgpm-devel
BuildRequires:  libldap-devel
BuildRequires:  libpam0-devel
BuildRequires:  pkgconfig(alsa)
BuildRequires:  pkgconfig(libjpeg)
BuildRequires:  pkgconfig(libpng)
BuildRequires:  pkgconfig(libtiff-4)
BuildRequires:  pkgconfig(ncurses)
BuildRequires:  pkgconfig(openssl)
BuildRequires:  pkgconfig(xau)
BuildRequires:  pkgconfig(xft)
BuildRequires:  pkgconfig(xpm)
BuildRequires:  pkgconfig(zlib)
BuildRequires:  makeinfo
BuildRequires:  gccmakedep imake lndir makedepend
%if %{with gtk}
BuildRequires:  pkgconfig(gtk+-3.0)
%else
BuildRequires:  xorg-bitmaps
%if %{with xaw3d}
BuildRequires:  pkgconfig(xaw3d)
%else
BuildRequires:  libneXtaw-devel
%endif
%endif
# Note: no xemacs-packages-extra dependency here, need main pkg to build it.
Requires:       xemacs-packages-base
Requires:       %{name}-common = %{version}-%{release}
Requires:       fonts-bitmap-75dpi
Requires:       fonts-bitmap-100dpi
Requires:       fonts-bitmap-misc
Requires(post): coreutils
Requires(postun): coreutils
Provides:       xemacs(bin) = %{version}-%{release}

# https://fedoraproject.org/wiki/Changes/Deprecate_xemacs
# https://bugzilla.redhat.com/show_bug.cgi?id=1916926
Provides:       deprecated()

%global xver    %(echo %{version} | sed -e 's/\\.\\([0-9]\\+\\)$/-b\\1/')
%global xbuild  %(echo %{_build} | sed -e 's/^\\([^-]*-[^-]*-[^-]*\\).*/\\1/')
Source44: import.info

%description
XEmacs is a highly customizable open source text editor and
application development system.  It is protected under the GNU General
Public License and related to other versions of Emacs, in particular
GNU Emacs.  Its emphasis is on modern graphical user interface support
and an open software development model, similar to Linux.

This package contains XEmacs built for X Windows%{?with_mule: with MULE support}.

%package        common
Group: Editors
Summary:        Lisp files and other common files for XEmacs
Requires:       %{name}-filesystem = %{version}-%{release}

# https://fedoraproject.org/wiki/Changes/Deprecate_xemacs
# https://bugzilla.redhat.com/show_bug.cgi?id=1916926
Provides:       deprecated()
Requires: rpm-macros-xemacs = %{version}-%{release}

%description    common
XEmacs is a highly customizable open source text editor and
application development system.  It is protected under the GNU General
Public License and related to other versions of Emacs, in particular
GNU Emacs.  Its emphasis is on modern graphical user interface support
and an open software development model, similar to Linux.

This package contains lisp and other common files for XEmacs.

%package        nox
Group: Editors
Summary:        Different version of Emacs built without X Windows support
# Note: no xemacs-packages* dependencies here, we need -nox to build the
# base package set.
Requires:       %{name}-common = %{version}-%{release}
Requires(post): coreutils
Provides:       xemacs(bin) = %{version}-%{release}

# https://fedoraproject.org/wiki/Changes/Deprecate_xemacs
# https://bugzilla.redhat.com/show_bug.cgi?id=1916926
Provides:       deprecated()

%description    nox
XEmacs is a highly customizable open source text editor and
application development system.  It is protected under the GNU General
Public License and related to other versions of Emacs, in particular
GNU Emacs.  Its emphasis is on modern graphical user interface support
and an open software development model, similar to Linux.

This package contains XEmacs built without X Windows support.

%package        xft
Group: Editors
Summary:        Different version of Emacs built with Xft/fontconfig support
Requires:       %{name}-common = %{version}-%{release}
Requires:       xemacs-packages-base
Requires(post): coreutils
Provides:       xemacs(bin) = %{version}-%{release}

# https://fedoraproject.org/wiki/Changes/Deprecate_xemacs
# https://bugzilla.redhat.com/show_bug.cgi?id=1916926
Provides:       deprecated()

%description    xft
XEmacs is a highly customizable open source text editor and
application development system.  It is protected under the GNU General
Public License and related to other versions of Emacs, in particular
GNU Emacs.  Its emphasis is on modern graphical user interface support
and an open software development model, similar to Linux.

This package contains XEmacs built with Xft and fontconfig support.

%package        info
Group: Documentation
Summary:        XEmacs documentation in GNU texinfo format
BuildArch:      noarch
Requires(post): info info-install
Requires(preun): info info-install

# https://fedoraproject.org/wiki/Changes/Deprecate_xemacs
# https://bugzilla.redhat.com/show_bug.cgi?id=1916926
Provides:       deprecated()

%description    info
XEmacs is a highly customizable open source text editor and
application development system.  It is protected under the GNU General
Public License and related to other versions of Emacs, in particular
GNU Emacs.  Its emphasis is on modern graphical user interface support
and an open software development model, similar to Linux.

This package contains XEmacs documentation in GNU texinfo format.

%package        devel
Group: Development/C
Summary:        Development files for XEmacs
Requires:       %{name} = %{version}-%{release}
Requires:       pkgconfig

# https://fedoraproject.org/wiki/Changes/Deprecate_xemacs
# https://bugzilla.redhat.com/show_bug.cgi?id=1916926
Provides:       deprecated()

%description    devel
XEmacs is a highly customizable open source text editor and
application development system.  It is protected under the GNU General
Public License and related to other versions of Emacs, in particular
GNU Emacs.  Its emphasis is on modern graphical user interface support
and an open software development model, similar to Linux.

This package contains XEmacs development support files.

%package        filesystem
Group: Editors
Summary:        XEmacs filesystem layout
BuildArch:      noarch

# https://fedoraproject.org/wiki/Changes/Deprecate_xemacs
# https://bugzilla.redhat.com/show_bug.cgi?id=1916926
Provides:       deprecated()

%description    filesystem
XEmacs is a highly customizable open source text editor and
application development system.  It is protected under the GNU General
Public License and related to other versions of Emacs, in particular
GNU Emacs.  Its emphasis is on modern graphical user interface support
and an open software development model, similar to Linux.

This package contains directories that are required by other packages that
add functionality to XEmacs.


%package -n rpm-macros-xemacs
Summary: Set of RPM macros for packaging sblim-cmpi applications
Group: Development/Other
BuildArch: noarch

%description -n rpm-macros-xemacs
Set of RPM macros for packaging sblim-cmpi applications for ALT Linux.
Install this package if you want to create RPM packages that use sblim-cmpi.

%prep
%setup -q -n %{name}-%{?snap:beta}%{!?snap:%{version}}
%patch0
%patch1
%patch2
%patch3
%patch4
%patch5
%patch6
%patch7
%patch8
%patch9
%patch10

find . -type f -name "*.elc" -o -name "*.info*" -delete
sed -i -e /tetris/d lisp/menubar-items.el

sed -e 's/"lib"/"%{_lib}"/' lisp/setup-paths.el > lisp/setup-paths.el.new
touch -r lisp/setup-paths.el lisp/setup-paths.el.new
mv -f lisp/setup-paths.el.new lisp/setup-paths.el

for f in man/internals/internals.texi man/lispref/mule.texi man/xemacs-faq.texi CHANGES-beta
do
    iconv -f iso-8859-1 -t utf-8 -o $f.utf8 $f
    touch -r $f $f.utf8
    mv -f $f.utf8 $f
done

# Get reproducible builds by setting the compiling username
mkdir ~/.xemacs
echo >> ~/.xemacs/custom.el << EOF
(custom-set-variables
 '(user-mail-address "mockbuild@fedoraproject.org"))
EOF


%build
CFLAGS="%{optflags} -fno-strict-aliasing"
export CFLAGS
export EMACSLOADPATH=$PWD/lisp:$PWD/lisp/mule
export LDFLAGS="%{build_ldflags}"

# The --with-*dir args can probably go away in the future if/when upstream
# configure learns to honor standard autofoo dirs better.
common_options="
    --mandir=%{_mandir}/man1
    --with-archlibdir=%{_libdir}/xemacs-%{xver}/%{xbuild}
%if %{with modules}
    --with-moduledir=%{_libdir}/xemacs-%{xver}/%{xbuild}/modules
%endif
    --with-lispdir=%{_datadir}/xemacs-%{xver}/lisp
    --with-etcdir=%{_datadir}/xemacs-%{xver}/etc
    --with-system-packages=%{_datadir}/xemacs
    --without-msw
%if %{with mule}
    --with-mule
    --with-unicode-internal
    --without-canna
%endif
    --with-clash-detection
    --with-database=gdbm
    --with-ldap
    --without-postgresql
    --with-mail-locking=lockf
    --with-pop
    --without-hesiod
    --with-tls=openssl
    --with-pdump
%if ! %{with modules}
    --without-modules
%endif
    --with-debug
    --with-error-checking=none
    --enable-bignum=gmp
    --with-union-type
"

%if %{with nox}
# build without X
%configure $common_options \
    --with-docdir=%{_libdir}/xemacs-%{xver}/doc-nox \
    --with-sound=none \
    --with-xim=no \
    --without-wnn \
    --without-x
make EMACSDEBUGPATHS=yes # toplevel parallel make fails
mv lib-src/DOC{,-nox}
mv src/xemacs{,-nox-%{xver}}
mv lib-src/config.values{,-nox}
mv Installation{,-nox}
%endif

# build with Xft
%configure $common_options \
    --with-docdir=%{_libdir}/xemacs-%{xver}/doc-xft \
    --with-sound=nonative,alsa \
    --with-xft=all \
%if %{with gtk}
    --with-gtk \
    --with-gnome \
%else
    --with-athena=%{?with_xaw3d:3d}%{!?with_xaw3d:next} \
    --with-menubars=lucid \
    --with-widgets=athena \
    --with-dialogs=athena \
    --with-scrollbars=lucid \
    --with-xim=%{?with_xim:xlib}%{!?with_xim:no} \
%endif
%if ! %{with wnn}
    --without-wnn
%endif
make EMACSDEBUGPATHS=yes # toplevel parallel make fails
mv lib-src/DOC{,-xft}
mv src/xemacs{,-xft-%{xver}}
mv lib-src/config.values{,-xft}
mv Installation{,-xft}

# build with X
%configure $common_options \
    --with-docdir=%{_libdir}/xemacs-%{xver}/doc \
    --with-sound=nonative,alsa \
%if %{with xft}
    --with-xft=all \
%else
%if %{with xfs}
    --with-xfs \
%endif
%endif
%if %{with gtk}
    --with-gtk \
    --with-gnome \
%else
    --with-athena=%{?with_xaw3d:3d}%{!?with_xaw3d:next} \
    --with-menubars=lucid \
    --with-widgets=athena \
    --with-dialogs=athena \
    --with-scrollbars=lucid \
    --with-xim=%{?with_xim:xlib}%{!?with_xim:no} \
%endif
%if ! %{with wnn}
    --without-wnn
%endif

make EMACSDEBUGPATHS=yes # toplevel parallel make fails

cat << \EOF > xemacs.pc
prefix=%{_prefix}
%if %{with modules}
includedir=%{_libdir}/xemacs-%{xver}/%{xbuild}/include
sitemoduledir=%{_libdir}/xemacs/site-modules
%endif
sitestartdir=%{_datadir}/xemacs/site-packages/lisp/site-start.d
sitepkglispdir=%{_datadir}/xemacs/site-packages/lisp

Name: xemacs
Description: Different version of Emacs
Version: %{version}
%if %{with modules}
Cflags: -I${includedir}
%endif
EOF

cat > macros.xemacs << EOF
%%_xemacs_version %{majver}
%%_xemacs_ev %{?epoch:%{epoch}:}%{version}
%%_xemacs_evr %{?epoch:%{epoch}:}%{version}-%{release}
%%_xemacs_sitepkgdir %{_datadir}/xemacs/site-packages
%%_xemacs_lispdir %{_datadir}/xemacs/site-packages/lisp
%%_xemacs_sitestartdir %{_datadir}/xemacs/site-packages/lisp/site-start.d
%%xemacs_bytecompile /usr/bin/xemacs -q -no-site-file -batch -eval '(push "." load-path)' -f batch-byte-compile
%if %{with modules}
%%_xemacs_includedir %{_libdir}/xemacs-%{xver}/%{xbuild}/include
%%_xemacs_sitemoduledir %{_libdir}/xemacs/site-modules
%endif
EOF

%install
%makeinstall_std

# Compress the .el files
find %{buildroot}%{_datadir}/xemacs-%{xver} -name \*.el -exec gzip --best {} \+

%if %{with nox}
# install nox files
echo ".so man1/xemacs.1" > $RPM_BUILD_ROOT%{_mandir}/man1/xemacs-nox.1
install -pm 755 src/xemacs-nox-%{xver} $RPM_BUILD_ROOT%{_bindir}
ln -s xemacs-nox-%{xver} $RPM_BUILD_ROOT%{_bindir}/xemacs-nox
install -dm 755 $RPM_BUILD_ROOT%{_libdir}/xemacs-%{xver}/doc-nox
install -pm 644 lib-src/DOC-nox \
    $RPM_BUILD_ROOT%{_libdir}/xemacs-%{xver}/doc-nox/DOC
install -pm 644 lib-src/config.values-nox \
    $RPM_BUILD_ROOT%{_libdir}/xemacs-%{xver}/doc-nox/config.values
%endif

# install xft files
echo ".so man1/xemacs.1" > $RPM_BUILD_ROOT%{_mandir}/man1/xemacs-xft.1
install -pm 755 src/xemacs-xft-%{xver} $RPM_BUILD_ROOT%{_bindir}
ln -s xemacs-xft-%{xver} $RPM_BUILD_ROOT%{_bindir}/xemacs-xft
install -dm 755 $RPM_BUILD_ROOT%{_libdir}/xemacs-%{xver}/doc-xft
install -pm 644 lib-src/DOC-xft \
    $RPM_BUILD_ROOT%{_libdir}/xemacs-%{xver}/doc-xft/DOC
install -pm 644 lib-src/config.values-xft \
    $RPM_BUILD_ROOT%{_libdir}/xemacs-%{xver}/doc-xft/config.values

# these clash with GNU Emacs
mv $RPM_BUILD_ROOT%{_bindir}/etags{,.xemacs}
rm -f $RPM_BUILD_ROOT%{_bindir}/{ctags,rcs-checkin,b2m}
mv $RPM_BUILD_ROOT%{_mandir}/man1/etags{,.xemacs}.1
rm -f $RPM_BUILD_ROOT%{_mandir}/man1/ctags.1
rm -f $RPM_BUILD_ROOT%{_infodir}/{cl,widget}.info*

# these clash with other packages
rm -f $RPM_BUILD_ROOT%{_infodir}/info*
rm -f $RPM_BUILD_ROOT%{_infodir}/standards*
rm -f $RPM_BUILD_ROOT%{_infodir}/termcap*
rm -f $RPM_BUILD_ROOT%{_infodir}/dir

desktop-file-install --mode=644 --dir=$RPM_BUILD_ROOT%{_datadir}/applications \
    %{SOURCE2}

desktop-file-install --mode=644 --dir=$RPM_BUILD_ROOT%{_datadir}/applications \
    %{SOURCE6}

# AppData file
mkdir -p $RPM_BUILD_ROOT%{_datadir}/appdata
install -pm 644 %{SOURCE1} $RPM_BUILD_ROOT%{_datadir}/appdata

# site-start.el
install -dm 755 \
    $RPM_BUILD_ROOT%{_datadir}/xemacs/site-packages/lisp/site-start.d
install -pm 644 %{SOURCE5} \
    $RPM_BUILD_ROOT%{_datadir}/xemacs/site-packages/lisp/site-start.el

# default.el
install -pm 644 %{SOURCE4} $RPM_BUILD_ROOT%{_datadir}/xemacs/site-packages/lisp

# default user init file
install -Dpm 644 %{SOURCE3} $RPM_BUILD_ROOT%{_sysconfdir}/skel/.xemacs/init.el

# icon
install -Dpm 644 etc/xemacs-icon.svg \
    $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/scalable/apps/xemacs.png

# macro file
install -Dpm 644 macros.xemacs $RPM_BUILD_ROOT%_rpmmacrosdir/xemacs

# Empty directories for external packages to use
mkdir -m 0755 $RPM_BUILD_ROOT%{_datadir}/xemacs/site-packages/etc
mkdir -m 0755 $RPM_BUILD_ROOT%{_datadir}/xemacs/site-packages/info
mkdir -m 0755 $RPM_BUILD_ROOT%{_datadir}/xemacs/site-packages/lib-src
mkdir -m 0755 $RPM_BUILD_ROOT%{_datadir}/xemacs/site-packages/man
mkdir -m 0755 $RPM_BUILD_ROOT%{_datadir}/xemacs/site-packages/pkginfo

# make sure nothing is 0400
chmod -R a+rX $RPM_BUILD_ROOT%{_prefix}
chmod a+x $RPM_BUILD_ROOT%{_datadir}/xemacs-%{xver}%{_sysconfdir}/xemacs-fe.sh

# clean up unneeded stuff (TODO: there's probably much more)
find $RPM_BUILD_ROOT%{_prefix} -name "*~" | xargs -r rm
rm $RPM_BUILD_ROOT%{_libdir}/xemacs-%{xver}/%{xbuild}/gzip-el.sh
rm $RPM_BUILD_ROOT{%{_bindir}/gnuattach,%{_mandir}/man1/gnuattach.1}
pushd $RPM_BUILD_ROOT%{_datadir}/xemacs-%{xver}/etc
rm -r InstallGuide tests XKeysymDB *.1
popd

# Generate file list and make site-packages lisp files config files.
# (Note: The double-quote before "(noreplace)" is only to work around
# a bug in rpm-spec-mode).
find $RPM_BUILD_ROOT \
  \( -path $RPM_BUILD_ROOT%{_datadir}/xemacs-%{xver} -o \
     -path $RPM_BUILD_ROOT%{_datadir}/xemacs-%{xver}/\* -o \
     -path $RPM_BUILD_ROOT%{_datadir}/xemacs/site-packages/lisp/\* \) -a \
  \( \( -type d -not -name site-start.d -fprintf base-files "%%%%dir /%%P\n" \) -o \
     \( -type f -path $RPM_BUILD_ROOT%{_datadir}/xemacs/site-packages/lisp/\*.el.gz -not -exec test -e {}c \; -fprintf base-files "%%%%config""(noreplace) /%%P\n" \) -o \
     \( -type f -fprintf base-files "/%%P\n" \) \)

sed -i '/\.cvsignore/d;/x-init\.el\.orig/d' base-files

install -Dpm 644 xemacs.pc $RPM_BUILD_ROOT%{_libdir}/pkgconfig/xemacs.pc
for rpm404_ghost in %{_bindir}/xemacs %{_bindir}/xemacs %{_bindir}/xemacs
do
    mkdir -p %buildroot`dirname "$rpm404_ghost"`
    touch %buildroot"$rpm404_ghost"
done
install -d $RPM_BUILD_ROOT/%_altdir; cat >$RPM_BUILD_ROOT/%_altdir/xemacs_xemacs<<EOF
%{_bindir}/xemacs	%{_bindir}/xemacs-%{xver}	80
EOF
install -d $RPM_BUILD_ROOT/%_altdir; cat >$RPM_BUILD_ROOT/%_altdir/xemacs_xemacs-nox<<EOF
%{_bindir}/xemacs	%{_bindir}/xemacs-nox-%{xver}	40
EOF
install -d $RPM_BUILD_ROOT/%_altdir; cat >$RPM_BUILD_ROOT/%_altdir/xemacs_xemacs-xft<<EOF
%{_bindir}/xemacs	%{_bindir}/xemacs-xft-%{xver}	40
EOF
install -d $RPM_BUILD_ROOT/%_altdir; cat >$RPM_BUILD_ROOT/%_altdir/etags_xemacs-common<<EOF
%{_bindir}/etags	%{_bindir}/etags.xemacs	40
EOF


%check
%make_build check


%files
%_altdir/xemacs_xemacs
%doc Installation
# gnuclient needs X libs, so not in -common
%{_bindir}/gnuclient
%{_bindir}/gnudoit
%{_bindir}/xemacs-%{xver}
%{_libdir}/xemacs-%{xver}/doc/
%{_datadir}/appdata/%{name}.appdata.xml
%{_datadir}/applications/%{name}.desktop
%{_datadir}/applications/gnuclient.desktop
%{_datadir}/icons/hicolor/scalable/apps/xemacs.png
%{_mandir}/man1/gnuclient.1*
%{_mandir}/man1/gnudoit.1*

%if %{with nox}
%files nox
%_altdir/xemacs_xemacs-nox
%doc Installation-nox
%{_bindir}/xemacs-nox
%{_bindir}/xemacs-nox-%{xver}
%{_libdir}/xemacs-%{xver}/doc-nox/
%{_mandir}/man1/xemacs-nox.1*
%endif

%files xft
%_altdir/xemacs_xemacs-xft
%doc Installation-xft
%{_bindir}/xemacs-xft
%{_bindir}/xemacs-xft-%{xver}
%{_libdir}/xemacs-%{xver}/doc-xft/
%{_mandir}/man1/xemacs-xft.1*

%files common -f base-files
%_altdir/etags_xemacs-common
%doc INSTALL README PROBLEMS CHANGES-beta etc/NEWS etc/TUTORIAL
%doc --no-dereference COPYING
%{_bindir}/etags.xemacs
%{_bindir}/ootags
%{_bindir}/xemacs-script
%dir %{_libdir}/xemacs-%{xver}/
%dir %{_libdir}/xemacs-%{xver}/%{xbuild}/
%{_libdir}/xemacs-%{xver}/%{xbuild}/[acdfghprsvwy]*
%{_libdir}/xemacs-%{xver}/%{xbuild}/m[am]*
%{_libdir}/xemacs-%{xver}/%{xbuild}/movemail
%if %{with modules}
%{_libdir}/xemacs/
%dir %{_libdir}/xemacs-%{xver}/%{xbuild}/modules/
%{_libdir}/xemacs-%{xver}/%{xbuild}/modules/auto-autoloads.el
%{_libdir}/xemacs-%{xver}/%{xbuild}/modules/auto-autoloads.elc
%{_libdir}/xemacs-%{xver}/%{xbuild}/modules/eldap.ell
%endif
%config(noreplace) %{_sysconfdir}/skel/.xemacs/
%{_mandir}/man1/etags.xemacs.1*
%{_mandir}/man1/gnuserv.1*
%{_mandir}/man1/xemacs.1*

%files info
%doc --no-dereference COPYING
%{_infodir}/*.info*

%files devel
%if %{with modules}
%{_bindir}/ellcc
%{_libdir}/xemacs-%{xver}/%{xbuild}/include/
%endif
%{_libdir}/pkgconfig/xemacs.pc

%files filesystem
%dir %{_datadir}/xemacs
%dir %{_datadir}/xemacs/site-lisp
%dir %{_datadir}/xemacs/site-packages
%dir %{_datadir}/xemacs/site-packages/etc
%dir %{_datadir}/xemacs/site-packages/info
%dir %{_datadir}/xemacs/site-packages/lib-src
%dir %{_datadir}/xemacs/site-packages/lisp
%dir %{_datadir}/xemacs/site-packages/lisp/site-start.d
%dir %{_datadir}/xemacs/site-packages/man
%dir %{_datadir}/xemacs/site-packages/pkginfo

%files -n rpm-macros-xemacs
%_rpmmacrosdir/*


%changelog
