# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:          xincluder
Version:       1.0d11
Release:       alt1_8
Summary:       Java class library that provides XInclude processing for existing XML APIs
Group:         Development/Java
License:       LGPL
Url:           http://xincluder.sourceforge.net/
Source0:       ftp://ftp.ibiblio.org/pub/languages/java/javafaq/xincluder-1.0d11.tar.gz
BuildRequires: ant
BuildRequires: java-devel-default /proc
BuildRequires: jdom
BuildRequires: javapackages-tools
BuildRequires: xerces-j2
BuildRequires: xml-commons-apis
Requires:      javapackages-tools
BuildArch:     noarch
Source44: import.info

%description
XIncluder is a Java class library that provides XInclude processing for existing XML APIs,
specifically SAX2, DOM2, and JDOM.

%package javadoc
Group:         Development/Java
Summary:       Javadoc for %{name}
BuildArch: noarch

%description javadoc
XIncluder is a Java class library that provides XInclude processing for existing XML APIs,
specifically SAX2, DOM2, and JDOM.

This package contains javadoc for %{name}.

%prep
%setup -q -n xincluder

iconv -f iso8859-1 -t utf-8 lgpl.txt > lgpl.txt.conv && mv -f lgpl.txt.conv lgpl.txt
sed -i 's/\r//' lgpl.txt

for j in $(find . -name "*.jar"); do
   mv $j $j.no
done
for j in $(find . -name "*.class"); do
   rm -f $j
done

ln -sf $(build-classpath jdom) lib/jdom-1.0b9rc.jar
ln -sf $(build-classpath xerces-j2) lib/xercesImpl-2.0.2.jar
ln -sf $(build-classpath xml-commons-apis) lib/xmlParserAPIs-2.0.2.jar

%build
export CLASSPATH=""
CLASSPATH=$CLASSPATH:$(build-classpath jdom):bin/classes
ant jar javadoc

%install
mkdir -p %{buildroot}%{_javadir}

install -m 0644 xincluder.jar \
  %{buildroot}%{_javadir}/xincluder-%{version}.jar

(
  cd %{buildroot}%{_javadir}
  for jar in *-%{version}.jar; do
    ln -sf ${jar} `echo $jar| sed "s|-%{version}||g"`
  done
)

mkdir -p %{buildroot}%{_javadocdir}/xincluder-%{version}
cp -pr apidoc/* %{buildroot}%{_javadocdir}/xincluder-%{version}
ln -s xincluder-%{version} %{buildroot}%{_javadocdir}/xincluder

%files
%{_javadir}/xincluder-%{version}.jar
%{_javadir}/xincluder.jar
%doc index.html lgpl.txt

%files javadoc
%{_javadocdir}/xincluder-%{version}
%{_javadocdir}/xincluder



%changelog
