Group: Communications
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           xnec2c
Version:        4.1.1
Release:        alt2_9
Summary:        GTK based graphical wrapper for nec2c

License:        GPLv2+
URL:            http://www.5b4az.org/
Source0:        http://www.5b4az.org/pkg/nec2/xnec2c/%{name}-%{version}.tar.bz2
Source100:      xnec2c.png
Patch0: xnec2c-configure-c99.patch

BuildRequires:  desktop-file-utils
BuildRequires:  gcc-c++
BuildRequires:  gtk3-demo libgail3-devel libgtk+3 libgtk+3-devel libgtk+3-gir-devel
BuildRequires:  glib2-devel libgio libgio-devel
BuildRequires:  intltool

Requires:       nec2c
Source44: import.info

%description
xnec2c is a GUI interactive application that (in its current form) reads NEC2
input files but presents output data in graphical form, e.g. as wire frame
drawings of the radiation pattern or near E/H field, graphs of maximum gain,
input impedance, vswr etc against frequency and simple rendering of the antenna
structure, including color code representation of currents or charge densities.

These results are only calculated and drawn on user demand via menu items or
buttons, e.g. xnec2c is interactive and does not execute NEC2 "commands" in
batch style as the original does. 


%prep
%setup -q
%patch0 -p1

%if 0%{?rhel}
    # Force lower version of intltool to be acceptable for RHEL.
    sed -i "s|0.50.0|0.40.0|g" configure
%endif


pushd examples
iconv --from=ISO-8859-1 --to=UTF-8 conductivity.txt > conductivity.txt.new && \
touch -r conductivity.txt conductivity.txt.new && \
mv conductivity.txt.new conductivity.txt


%build
%configure
%make_build CFLAGS="%{optflags}"


%install
%makeinstall_std

mkdir -p %{buildroot}%{_datadir}/icons/hicolor/256x256/apps
install -pm 644 %{SOURCE100} \
  %{buildroot}%{_datadir}/icons/hicolor/256x256/apps/
desktop-file-install --vendor="" \
  --dir=%{buildroot}%{_datadir}/applications \
  files/%{name}.desktop

# Remove incorrectly installed files by make
rm -rf %{buildroot}%{_docdir}/%{name}/*.1.gz \
       %{buildroot}%{_datadir}/pixmaps

%if 0%{?fedora}
# Appdata
mkdir -p %{buildroot}%{_datadir}/appdata
cat > %{buildroot}%{_datadir}/appdata/%{name}.appdata.xml << EOF
<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright 2017 Richard Shaw <hobbes1069@gmail.com> -->
<component type="desktop">
  <id>%{name}.desktop</id>
  <metadata_license>CC0-1.0</metadata_license>
  <project_license>GPL-2.0+</project_license>
  <name>xnec2c</name>
  <summary>GTK based graphical wrapper for nec2c</summary>
  <description>
    <p>
nec2c is a GUI interactive application that (in its current form) reads NEC2
input files but presents output data in graphical form, e.g. as wire frame
drawings of the radiation pattern or near E/H field, graphs of maximum gain,
input impedance, vswr etc against frequency and simple rendering of the antenna
structure, including color code representation of currents or charge densities.
    </p>
  </description>
  <screenshots>
    <screenshot type="default">
      <image>http://www.5b4az.org/pkg/nec2/xnec2c/doc/images/radiation.png</image>
    </screenshot>
  </screenshots>
  <url type="homepage">%{url}</url>
  <update_contact>hobbes1069@gmail.com</update_contact>
</component>
EOF
%endif


%files
%doc AUTHORS ChangeLog README
%doc doc/NearFieldCalcs.txt doc/NEC2-bug.txt doc/nec2c.txt doc/xnec2c.html
%doc doc/images
%doc examples
%doc --no-dereference COPYING
%{_bindir}/*
%{_datadir}/%{name}/
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/256x256/apps/%{name}.png
%{_datadir}/icons/hicolor/scalable/apps/%{name}.svg
%{?fedora:%{_datadir}/appdata/%{name}.appdata.xml}
%{_mandir}/man1/%{name}.*


%changelog
