Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           xorsearch
Version:        1.11.2
Release:        alt2_6
Summary:        Search for a given string in an XOR, ROL, ROT or SHIFT encoded binary file

License:        Public Domain
URL:            http://blog.didierstevens.com/programs/xorsearch/

%global pkgver %(echo %{version} | sed 's/\\./_/g')
Source0:        http://didierstevens.com/files/software/XORSearch_V%{pkgver}.zip
Patch0:         %{name}-cosmetics.patch

BuildRequires:  gcc
Source44: import.info

%description
XORSearch is a program to search for a given string in an XOR, ROL, ROT or SHIFT
encoded binary file. An XOR encoded binary file is a file where some (or all)
bytes have been XORed with a constant value (the key). A ROL (or ROR) encoded
file has its bytes rotated by a certain number of bits (the key). A ROT encoded
file has its alphabetic characters (A-Z and a-z) rotated by a certain number
of positions. A SHIFT encoded file has its bytes shifted left by a certain
number of bits (the key): all bits of the first byte shift left, the MSB
of the second byte becomes the LSB of the first byte, all bits of the second
byte shift left, a.. XOR and ROL/ROR encoding is used by malware programmers
to obfuscate strings like URLs.


%prep
%setup -q -c
%patch0 -p 1 -b .cosmetics
#remove binaries
rm -rf OSX Linux XORSearch.exe

%build
# gcc %{optflags} -Wno-trigraphs XORSearch.c -o %{name}
gcc %{optflags} -Wno-trigraphs -D __APPLE__=1 XORSearch.c -o %{name}


%install
#Targetting EPEL as well
rm -rf "%{buildroot}"
install -m 755 -D %{name} "%{buildroot}/%{_bindir}/%{name}"


%files
%{_bindir}/%{name}

%changelog
