Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/bison
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           xqilla
Version:        2.3.3
Release:        alt2_14
Summary:        XQuery and XPath 2.0 library, built on top of Xerces-C

License:        ASL 2.0
URL:            http://xqilla.sourceforge.net/HomePage
Source0:        http://downloads.sourceforge.net/xqilla/XQilla-%{version}.tar.gz
Source1:        xqilla.1
# since header xqc.h is provided by xqc
Patch0:         xqilla-2.2.4-use-system-xqc.h.patch
# Fix library soname to be compatible with 2.3.0; patch taken from
# http://http.debian.net/debian/pool/main/x/xqilla/xqilla_2.3.3-3.debian.tar.xz
Patch1:         0002-Fix-library-s-libtool-version.patch
# Fix the build with xerces-c 3.2; patch taken from
# http://http.debian.net/debian/pool/main/x/xqilla/xqilla_2.3.3-3.debian.tar.xz
Patch2:         0004-xerces-3.2.0-casts.patch
Patch3:         0005-xqilla-gcc11.patch

BuildRequires:  gcc-c++
BuildRequires:  libxerces-c-devel >= 3.0.1 
BuildRequires:  xqc
BuildRequires:  doxygen graphviz libgraphviz
# For patch1:
BuildRequires:  autoconf automake libtool
Source44: import.info

%description
XQilla is an XQuery and XPath 2.0 implementation written in C++ and based
on Xerces-C. It implements the DOM 3 XPath API, as well as having it's own
more powerful API. It conforms to the W3C proposed recommendation of XQuery
and XPath 2.0.

%package        devel
Group: Development/Other
Summary:        XQilla is an XQuery and XPath 2.0 library, built on top of Xerces-C
Requires:       %{name} = %{version}-%{release}
Requires:       xqc

%description    devel
XQilla is an XQuery and XPath 2.0 implementation written in C++ and based
on Xerces-C. It implements the DOM 3 XPath API, as well as having it's own
more powerful API. It conforms to the W3C proposed recommendation of XQuery
and XPath 2.0.

%package        doc
Group: Documentation
Summary:        XQilla documentation
BuildArch:      noarch

%description    doc
simple-api and dom3-api documentation for XQilla.

%prep
%setup -q -n XQilla-%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1


%build
# For patch1:
autoreconf -fi
# ensure that xqc.h is not used
rm -f ./include/xqc.h
%configure \
  --disable-static \
  --with-xerces=%{_prefix}

# Avoid lib64 rpaths
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool

%make_build
make docs

%install
# force timestamp preservation when using install program
make install DESTDIR=%{buildroot} INSTALL="install -p"
find %{buildroot} -name '*.la' -exec rm -f '{}' ';'
install -D -p -m0664 %{SOURCE1} %{buildroot}/%{_mandir}/man1/%{name}.1



%files
%doc --no-dereference LICENSE
%doc ChangeLog
%{_bindir}/xqilla
%{_libdir}/libxqilla.so.*
%{_mandir}/man1/%{name}.1*

%files devel
%{_libdir}/libxqilla.so
%{_includedir}/xqilla/

%files doc
%doc --no-dereference LICENSE
%doc docs/dom3-api/ docs/simple-api/


%changelog
