Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           xrotor
Version:        7.55
Release:        alt2_29
Summary:        Design and analysis tools for propellers and windmills

# Plotlib is LGPLv2+, the rest is GPLv2+
# Automatically converted from old format: GPLv2+ and LGPLv2+ - review is highly recommended.
License:        GPL-2.0-or-later AND LicenseRef-Callaway-LGPLv2+
URL:            http://web.mit.edu/drela/Public/web/xrotor/
Source0:        http://web.mit.edu/drela/Public/web/xrotor/Xrotor%{version}.tar.tgz
# The package does not ship a license file
Source1:        LICENSE.GPL
Source2:        LICENSE.LGPL
# Makefile variables and flags
Patch0:         Xrotor7.55-makefile.patch

BuildRequires:  gcc-fortran libX11-devel
Requires:       fonts-bitmap-misc
Source44: import.info


%description
XROTOR is an interactive program for the design and analysis of propellers
and windmills. It includes
 1. Design of minimum induced loss rotor (propeller or windmill)
 2. Prompted input of an arbitrary rotor geometry
 3. Interactive modification of a rotor geometry
and many others.


%prep
%setup -q -n Xrotor
%patch0 -p1

cp %{SOURCE1} .
cp %{SOURCE2} .


%build
export FFLAGS="-fallow-argument-mismatch %{optflags}"
export CFLAGS="%{optflags}"

%make_build -C plotlib
%make_build -C bin


%install
%makeinstall_std -C bin BINDIR=%{_bindir}


%files
%doc version_notes.txt xrotor_doc.txt
%doc --no-dereference LICENSE.GPL LICENSE.LGPL
%{_bindir}/xrotor
%{_bindir}/jplot
%{_bindir}/jplote


%changelog
