Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# xschem Package description for Fedora/Free Electronic Lab
#
%global rpm_has_recommends    %(rpm --version | awk -e '{print ($3 > 4.12)}')
#
Name:           xschem
Version:        3.1.0
Release:        alt1_6
Summary:        Schematic capture and Netlisting EDA tool

License:        GPL-2.0-or-later
URL:            http://repo.hu/projects/xschem
Source0:        http://repo.hu/projects/xschem/releases/xschem-%{version}.tar.gz

BuildRequires:  gcc
BuildRequires:  gawk
BuildRequires:  flex, bison
#BuildRequires:  flex-devel
BuildRequires:  tcl-devel
BuildRequires:  tk-devel
BuildRequires:  pkgconfig(xpm)
BuildRequires:  pkgconfig(cairo-xcb)
#BuildRequires:  cairo-devel
#BuildRequires:  xcb-util-devel

%if %rpm_has_recommends
Requires:     %{name}-doc = %{version}-%{release}
%endif
Source44: import.info

#Requires:   tcl, tk


%description
%{name} is a schematic capture program, it allows creation of hierarchical
representation of circuits with a top down approach. By focusing on
interfaces, hierarchy and instance properties, a complex system can be
described in terms of simpler building blocks. A VHDL or Verilog or Spice
netlist can be generated from the drawn schematic, allowing the simulation
of the circuit. Key feature of the program is its drawing engine written in C
and using directly the Xlib drawing primitives; this gives very good
speed performance, even on very big circuits. The user interface is
built with the Tcl-Tk toolkit, Tcl is also the extension language used.

%package doc
Group: Other
Summary:        Documentation for %{name}
BuildArch:      noarch

%description doc
Documentation for %{name}.


%prep
%setup -q



%build
./"configure" --CFLAGS="%{optflags}" --LDFLAGS="%{build_ldflags}" \
    --prefix=%{_prefix} --symbols
%make_build


%install
%makeinstall_std


%files
%doc --no-dereference LICENSE
%doc AUTHORS Changelog README
%{_bindir}/%{name}
%{_bindir}/rawtovcd
%{_datadir}/%{name}
%{_mandir}/man1/xschem.1*


%files doc
%{_docdir}/%{name}


%changelog
