Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install imake libICE-devel libSM-devel libXt-devel libmikmod-devel libopenmotif-devel libreadline-devel xorg-cf-files
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		xscorch
Version:	0.2.1
Release:	alt3_29
Summary:	A Scorched Earth clone
License:	GPL-2.0-only
URL:		http://www.xscorch.org/
Source0:	http://www.xscorch.org/releases/%{name}-%{version}.tar.gz
Source1:	xscorch.desktop
Source2:        xscorch.png
Source3:        xscorch.appdata.xml
Patch1:		xscorch-0.2.1-pre2-disable-debug.patch
Patch2:		xscorch-0.2.1-missing-proto.patch
Patch3:		xscorch-0.2.1-memcpy.patch
BuildRequires:  gcc
BuildRequires:	libX11-devel gtk-builder-convert gtk-demo libgail-devel libgtk+2-devel desktop-file-utils libappstream-glib libappstream-glib-gir
BuildRequires:	perl-devel
Requires:       icon-theme-hicolor
Source44: import.info

%description
xscorch is a clone of the classic DOS game, "Scorched Earth". The basic goal
is to annihilate enemy tanks using overpowered guns :). Basically, you buy
weapons, you target the enemy by adjusting the angle of your turret and firing
power, and you hope to destroy their tank before they destroy yours.


%prep
%setup -q
%patch1  -p1
%patch2  -p1
%patch3  -p1
# Fix encoding
for i in AUTHORS ChangeLog; do
	iconv -f ISO-8859-1 -t UTF-8 < ${i} > ${i}.tmp
	mv -f ${i}.tmp ${i}
done


%build
export CPPFLAGS="$CPPFLAGS -fcommon -std=gnu17"
%configure --disable-network --disable-sound
%make_build


%install
%makeinstall_std INSTALL="install -p"

# below is the desktop file and icon stuff.
mkdir -p $RPM_BUILD_ROOT%{_datadir}/applications
desktop-file-install --dir $RPM_BUILD_ROOT%{_datadir}/applications %{SOURCE1}
mkdir -p $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/64x64/apps
install -p -m 644 %{SOURCE2} \
  $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/64x64/apps
mkdir -p $RPM_BUILD_ROOT%{_datadir}/appdata
install -p -m 644 %{SOURCE3} $RPM_BUILD_ROOT%{_datadir}/appdata
appstream-util validate-relax --nonet \
  $RPM_BUILD_ROOT%{_datadir}/appdata/xscorch.appdata.xml

%files
%doc doc/AI AUTHORS ChangeLog doc/NETWORK doc/NOTES README
%doc --no-dereference COPYING
%{_bindir}/xscorch
%{_datadir}/appdata/xscorch.appdata.xml
%{_datadir}/applications/xscorch.desktop
%{_mandir}/man6/xscorch.6*
%{_datadir}/xscorch/
%{_datadir}/icons/hicolor/64x64/apps/xscorch.png


%changelog
