Group: Toys
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define fontpkgname yadex
Name:           yadex
Version:        1.7.0
Release:        alt2_53
Summary:        Doom level editor
License:        GPLv2+

URL:            http://www.teaser.fr/~amajorel/yadex

Source0:        http://www.teaser.fr/~amajorel/yadex/yadex-1.7.0.tar.gz
Source1:        yadex.desktop
Source2:        yadex.png

Patch0:         http://glbsp.sourceforge.net/yadex/Yadex_170_ALL.diff
Patch1:         http://glbsp.sourceforge.net/yadex/Yadex_170_Hexen.diff
Patch2:         yadex-1.7.0-64bit.patch
Patch3:         yadex-1.7.0-destdir.patch
Patch4:         yadex-1.7.0-datadir.patch
Patch5:         yadex-1.7.0-gcc41.patch
Patch6:         yadex-1.7.0.bareelif.patch
Patch7:         yadex-1.7.0-obj-overflow.patch
# The following patch is a difference between
# the Mr.Meval's huge patch (called "allpatches")
# attached to Bug 830628 and the upstream version
# 1.7.0 with local Fedora patches #0-7.
# It finally introduces changes contained
# in the omitted HEXEN patch #1 and other fixes
Patch8:         yadex-1.7.0-mrmeval-differential-patch.patch

BuildRequires:  desktop-file-utils
BuildRequires:  libX11-devel
BuildRequires:  boost-complete
# Required by scripts/copyright
BuildRequires:  perl-devel
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Getopt/Long.pm)
BuildRequires:  gcc-c++

# Yadex needs an iwad to run.  freedoom provides a free iwad that we can use.
Requires:       freedoom fonts-bitmap-75dpi
Source44: import.info

%description
Yadex is a Doom level (wad) editor for Unix systems running X, including Linux.
It supports Doom alpha, Doom beta, Doom, Ultimate Doom, Final Doom, Doom II,
Heretic and also, in a more or less limited way, Hexen and Strife.

Yadex is descended from DEU 5.21. Therefore, as you might expect, it's a rather
low-level editor that requires you to take care of a lot of detail but on the
flip side allows you to control very precisely what you are doing. In addition,
it has many advanced functions that DEU didn't have, to make certain
tedious tasks easy.


%prep
%setup -q

# Removing bundled boost
rm -rf boost

%patch0 -p1
# Omitted. Patch fails to apply. Used for Hexen maps only. Needs investigation.
#%%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p0
%patch8 -p1


%build

# Don't use %%configure because this is not an autotools-generated
# configure script and will choke on some of the default configure switches.
./configure --prefix=%{_prefix}

# Disabling optimizations (#830628 - crash workaround)
CXXFLAGS_NOOPT=`echo "%{optflags}" | sed "s/-O2//g"`
make CXXFLAGS="$CXXFLAGS_NOOPT" CXX="g++ -std=gnu++03" %{?_smp_mflags}


%install
make install DESTDIR="%{buildroot}"

# Remove the duplicate man pages
rm -f %{buildroot}%{_mandir}/man6/%{name}*
iconv --from=ISO-8859-1 --to=UTF-8 docsrc/%{name}.6 > docsrc/%{name}.6.new
install -p -m644 docsrc/%{name}.6.new %{buildroot}/%{_mandir}/man6/%{name}.6

# .desktop file integration
desktop-file-install                             \
        --dir %{buildroot}%{_datadir}/applications         \
        %{SOURCE1}
mkdir -p %{buildroot}/%{_datadir}/icons/hicolor/48x48/apps/
install -p -m 644 %{SOURCE2} %{buildroot}/%{_datadir}/icons/hicolor/48x48/apps/

%files
%{_bindir}/%{name}
%{_bindir}/%{name}-%{version}
%dir %{_sysconfdir}/%{name}
%dir %{_sysconfdir}/%{name}/%{version}
%config(noreplace) %{_sysconfdir}/%{name}/%{version}/%{name}.cfg
%{_datadir}/%{name}
%{_mandir}/man6/*
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/48x48/apps/yadex.png
%doc doc/*.html docsrc/*.png
%doc --no-dereference COPYING COPYING.LIB

%changelog
