# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/glib-gettextize dante libssl-devel texinfo
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# https://bugzilla.redhat.com/bugzilla/show_bug.cgi?id=192606
#
# Specfile for yafc: yet another ftp client
#

Name:           yafc
Version:        1.3.5
Release:        alt1_9
Summary:        Yet Another FTP/SFTP Client

Group:          Networking/WWW
License:        GPLv2+
URL:            http://yafc.sourceforge.net

################################################################################

Source:         http://www.yafc-ftp.com/upload/%{name}-%{version}.tar.xz

################################################################################

BuildRequires:  gcc
BuildRequires:      readline-devel >= 4.2
BuildRequires:      libkrb5-devel
BuildRequires:      libncurses++-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel
BuildRequires:      /usr/bin/makeinfo
BuildRequires:      libbsd-devel
BuildRequires:      gettext-tools libasprintf-devel
BuildRequires:      libssh-devel
# FIXME: The editline configure check is broken
BuildRequires:      libedit-devel

Requires:           openssh-clients openssh-common
Source44: import.info


################################################################################

%description
Yafc is an OpenSource console mode FTP client. It has support for Kerberos 4/5
authentication and sftp (ssh2). Other features include tab completion,
directory cache, powerful aliases, recursive file commands and bookmarks with
autologin.

################################################################################

%prep

%setup -q

################################################################################

%build

%configure

%make_build

################################################################################

%install

make install DESTDIR=$RPM_BUILD_ROOT

# Change the perms on %doc files so rpm doesn't pick up their dependencies
find contrib/ -type f -print0 | xargs -r0 chmod 644

# Remove the info directory that sometimes gets created
rm -rf $RPM_BUILD_ROOT/%{_datadir}/info/dir

################################################################################

%files
%doc BUGS COPYING COPYRIGHT NEWS README.md THANKS TODO
%doc contrib/
%doc samples/inputrc samples/yafcrc
%{_bindir}/*
%{_mandir}/man*/*
%{_datadir}/info/yafc*
%{_sysconfdir}/bash_completion.d/yafc
%{_datadir}/locale/*/LC_MESSAGES/yafc.mo

################################################################################

%changelog
