Group: Shells
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /proc
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name yash
# Upstream SCM
# Upstream is currently using SVN
# SVN path: http://svn.sourceforge.jp/svnroot/yash/yash/trunk

%global		mainver		2.59
%global		docver		%{mainver}

%global		yashdocdir		%{_datadir}/doc/%{name}-doc

%global		baserelease	2
%undefine		minorver
%undefine       _changelog_trimtime

Name:		yash
Version:	%{mainver}
Release:	alt1_2
Summary:	Yet Another SHell

# License header in .c files are GPL-2.0-or-later
# However, doc/intro.txt says this is under GPL-2.0-only
# SPDX confirmed
License:	GPL-2.0-only
URL:		https://github.com/magicant/yash/
Source0:	https://github.com/magicant/yash/archive/%{version}/%{name}-%{version}%{?minorver}.tar.gz

# Patches

BuildRequires:	gcc
BuildRequires:	libncurses++-devel libncurses++w-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel
BuildRequires:	ed
BuildRequires:	/usr/bin/a2x
BuildRequires:	/usr/bin/asciidoc
BuildRequires:	/usr/bin/xgettext
BuildRequires:	/bin/ps
Provides:		/bin/yash
# Write needed Requires for scriptlets explicitly
Requires(post):	grep
Requires(post):	coreutils
Requires(postun):	sed
Source44: import.info


%description
Yash is a command line shell that conforms to the POSIX.1 (IEEE Std
1003.1, 2008 Edition) standard for the most part.

Yash also has its own features beyond POSIX, such as:
  * global aliases
  * random numbers
  * socket redirections and other special redirections
  * right prompt
  * command completion


%package	doc
Group: Documentation
Summary:	Documentation for %{name}
Version:	%{docver}
License:	CC-BY-SA-2.1-JP
BuildArch:	noarch
Requires:	%{name} = %{mainver}-%{release}
#Requires:	%{name} >= %{version}

%description	doc
This package contains document files for %{name}.

%prep
%setup -q

%build
# This package use configure not based on autotools...
# won't accept --libdir=
./configure \
	--prefix=%{_prefix} \
	--exec-prefix=%{_exec_prefix} \
	--bindir=%{_bindir} \
	--datarootdir=%{_datarootdir} \
	--docdir=%{yashdocdir}/ \

%make_build -k

%install
make install install-html \
	DESTDIR=$RPM_BUILD_ROOT \
	INSTALL="install -p" \
	CPPROG="cp -p"

%find_lang %{name}

%check
export LANG=en_US.UTF-8
teststatus=0
make test || teststatus=1

cat tests/summary.log
sleep 3
exit $teststatus


%post
if [ -f %{_sysconfdir}/shells ]
then
	grep -q '^/bin/yash$' %{_sysconfdir}/shells || echo '/bin/yash' >> %{_sysconfdir}/shells
else
	echo '/bin/yash' > %{_sysconfdir}/shells
fi
exit 0

%postun
[ -f %{_sysconfdir}/shells ] || exit 0
sed -i -e '\@/bin/yash$@d' %{_sysconfdir}/shells
exit 0

%files -f %name.lang
%doc --no-dereference	COPYING
%doc	NEWS
%doc	README.md
%lang(ja)	%doc	NEWS.ja
%lang(ja)	%doc	README.ja.md

%{_bindir}/%{name}

%dir	%{_datadir}/%{name}
%{_datadir}/%{name}/completion/
%{_datadir}/%{name}/config
%{_datadir}/%{name}/initialization/

%{_mandir}/man1/yash.1*
%lang(ja)	%{_mandir}/ja/man1/yash.1*

%files	doc
%dir	%{yashdocdir}/
%{yashdocdir}/*.html
%{yashdocdir}/*.css
%lang(ja)	%{yashdocdir}/ja/

%changelog
