Group: File tools
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary: Zorba's Incredible Data Repairer And Verifier
Name: zidrav
Version: 1.2.0
Release: alt2_29
URL: https://sourceforge.net/projects/zidrav
Source: https://downloads.sourceforge.net/project/zidrav/zidrav4unix/%{version}/zidrav4unix-%{version}.tar.gz
Patch0: %{name}-rpm.patch
Patch1: %{name}-gcc43.patch
Patch2: %{name}-gcc60.patch
Patch3: %{name}-cxx11.patch
License: GPLv2+

BuildRequires:  gcc-c++
Source44: import.info
%description
ZIDRAV stands for "Zorba's Incredible Data Repairer And Verifier", and is an
extremely useful tool for cross-checking files that have been transfered via
HTTP, FTP, or some other method. What it does, is generates a checksum file,
and then by comparing that checksum with the original file, it creates a patch
file that can repair the corrupted file. Very cool, and saves re-downloading.

%prep
%setup -q -n zidrav4unix-%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1

# fix DOS line endings
tr -d '\r' <zidrav.txt >zidrav.txt.cr && mv zidrav.txt.cr zidrav.txt

%build

%ifarch ppc64 s390x
export CXXFLAGS="$CXXFLAGS -DCPU_BIGENDIAN"
%endif
%make_build CXXFLAGS="$CXXFLAGS"

%install
%makeinstall_std

%files
%doc Changelog README TODO zidrav.txt
%doc --no-dereference COPYING
%{_bindir}/%{name}
%{_mandir}/man1/%{name}.1*

%changelog
