Group: Sound
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}

Summary:       Audio autotuner for JACK
Name:          zita-at1
Version:       0.6.2
Release:       alt1_7
License:       GPLv2+
URL:           http://kokkinizita.linuxaudio.org/
Source0:       http://kokkinizita.linuxaudio.org/linuxaudio/downloads/%{name}-%{version}.tar.bz2
# submitted upstream
Source1:       %{name}.desktop

BuildRequires: libcairo-devel
BuildRequires: libfftw3-devel
BuildRequires: gcc-c++
BuildRequires: zita-resampler-devel
BuildRequires: libpng-devel libpng17-tools
BuildRequires: libjack-devel
BuildRequires: zita-alsa-pcmi-devel
BuildRequires: clthreads-devel
BuildRequires: clxclient-devel >= 3.9.0
BuildRequires: libXft-devel
BuildRequires: desktop-file-utils
Source44: import.info

%description
%{name} is an 'autotuner', normally used to correct the pitch of a voice 
singing (slightly) out of tune.

%prep
%setup -q
%add_optflags -I/usr/include/freetype2

sed -i -e 's|-march=native|%{optflags}|' -e 's|-ffast-math||' \
    source/Makefile

%build
cd source
make PREFIX=%{_prefix} LDFLAGS="$RPM_LD_FLAGS" %{?_smp_mflags}

%install
cd source
make DESTDIR=%{buildroot} PREFIX=%{_prefix} LIBDIR=%{_lib} install

# .desktop file
mkdir -p %{buildroot}%{_datadir}/applications
desktop-file-install  \
   --dir=%{buildroot}%{_datadir}/applications %{SOURCE1}

mkdir -p %{buildroot}%{_datadir}/pixmaps
install -m 644 %{_builddir}/%{name}-%{version}/doc/redzita.png \
    %{buildroot}%{_datadir}/pixmaps/%{name}.png


%files
%doc AUTHORS doc/*
%doc --no-dereference COPYING
%{_bindir}/%{name}
%{_datadir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_datadir}/pixmaps/%{name}.png

%changelog
