Group: Sound
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}

Summary:       Pro-audio reverb for JACK
Name:          zita-rev1
Version:       0.2.2
Release:       alt1_6
License:       GPLv2+
URL:           http://kokkinizita.linuxaudio.org/
Source0:       http://kokkinizita.linuxaudio.org/linuxaudio/downloads/%{name}-%{version}.tar.bz2
# desktop file submitted upstream
Source1:       zita-rev1.desktop

# this has been submitted upstream
Patch0:        zita-rev1-fsf-address.patch

BuildRequires: libcairo-devel
BuildRequires: gcc-c++
BuildRequires: libpng-devel libpng17-tools
BuildRequires: libjack-devel
BuildRequires: libXft-devel
BuildRequires: clthreads-devel
BuildRequires: clxclient-devel
BuildRequires: desktop-file-utils
Source44: import.info

%description
%{name} is a reworked version of the reverb originally developed for Aeolus. 
Its character is more 'hall' than 'plate', but it can be used on a wide 
variety of instruments or voices. 
It is not a spatialiser - the early reflections are different for the L and R 
inputs, but do not correspond to any real room. They have been tuned to match 
left and right sources to some extent.

In Stereo mode a dry/wet mix control is provided, so it can be used either as
an insert or in send/return mode. For mono just connect one of the two 
channels.

In Ambisonic mode (selected by the -B command line option) the only option is 
the send/return mode. 

%prep
%setup -q
%patch0 -p1

%add_optflags -I/usr/include/freetype2
# use Fedora build flags
sed -e '/^CXXFLAGS += -march=native/d' -i source/Makefile

%build
export CXXFLAGS="%optflags"

cd source
%make_build PREFIX=%{_prefix}

%install
cd source
make DESTDIR=%{buildroot} PREFIX=%{_prefix} LIBDIR=%{_lib} install

# .desktop file
mkdir -p %{buildroot}%{_datadir}/applications
desktop-file-install  \
   --dir=%{buildroot}%{_datadir}/applications %{SOURCE1}

mkdir -p %{buildroot}%{_datadir}/pixmaps
install -m 644 %{_builddir}/%{name}-%{version}/doc/redzita.png %{buildroot}%{_datadir}/pixmaps/%{name}.png

%files
%doc AUTHORS doc/*
%doc --no-dereference COPYING
%{_bindir}/%{name}
%{_datadir}/%{name}
%{_datadir}/pixmaps/%{name}.png
%{_datadir}/applications/%{name}.desktop



%changelog
