Group: Sciences/Mathematics
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-R
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%bcond_with check

%global packname  acepack
%global packver   1.4.1

Name:             R-%{packname}
Version:          %{packver}
Release:          alt1_25
Summary:          ACE and AVAS methods for choosing regression transformations
License:          Public Domain and MIT
URL:              http://cran.r-project.org/web/packages/acepack/index.html
Source0:          http://cran.r-project.org/src/contrib/%{packname}_%{packver}.tar.gz
Source1:          ace-copyright.txt
BuildRequires:    R-devel >= 3.4.0, gcc-fortran
%if %{with check}
BuildRequires:    R-testthat
%endif
Source44: import.info
ExcludeArch: %R_exclude_arches

%description
ACE and AVAS (additivity and variance stabilization) are used to estimate 
transformations for regression.

%prep
%setup -c -q -n %{packname}
cp %{SOURCE1} .
%build

%install
mkdir -p %{buildroot}%{_libdir}/R/library
R CMD INSTALL %{packname} -l %{buildroot}%{_libdir}/R/library 
# Clean up in advance of check
test -d %{packname}/src && (cd %{packname}/src; rm -f *.o *.so)
rm -rf %{buildroot}%{_libdir}/R/library/R.css

%check
%if %{with check}
%{_bindir}/R CMD check %{packname}
%endif

%files
%dir %{_libdir}/R/library/%{packname}
%doc %{_libdir}/R/library/%{packname}/html
%doc %{_libdir}/R/library/%{packname}/DESCRIPTION
%doc %{_libdir}/R/library/%{packname}/NEWS
%doc %{_libdir}/R/library/%{packname}/README*
%doc %{_libdir}/R/library/%{packname}/ace.doc
%{_libdir}/R/library/%{packname}/LICENSE
%doc --no-dereference ace-copyright.txt
%{_libdir}/R/library/%{packname}/INDEX
%{_libdir}/R/library/%{packname}/libs/
%{_libdir}/R/library/%{packname}/Meta
%{_libdir}/R/library/%{packname}/NAMESPACE
%{_libdir}/R/library/%{packname}/R
%{_libdir}/R/library/%{packname}/help

%changelog
