Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-R
BuildRequires: tex(dehypht.tex) texlive-dist
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define packname car
%global packver 2.0
# Note that some R packages do not use packrel
%define packrel 22

%global __suggests_exclude ^R\\((MatrixModels|SparseM|alr4|leaps|lme4|pbkrtest|quantreg|rgl|survey)\\)

Name:             R-%{packname}
Version:          %{packver}.%{packrel}
Release:          alt2_20
Source0:          http://cran.r-project.org/src/contrib/car_%{packver}-%{packrel}.tar.gz
License:          GPLv2+
URL:              http://cran.r-project.org/web/packages/car/index.html
Summary:          Companion to Applied Regression package for R
BuildRequires:    R-devel, tex(latex)
BuildArch:        noarch
Source44: import.info
ExcludeArch: %R_exclude_arches

%description
This package accompanies J. Fox, An R and S-PLUS Companion to Applied
Regression, Sage, 2002. The package contains mostly functions for applied
regression, linear models, and generalized linear models, with an emphasis on
regression diagnostics, particularly graphical diagnostic methods.  There are
also some utility functions. With some exceptions, it does not duplicate
capabilities in the basic distribution of R, nor in widely used packages.
Where relevant, the functions in car are consistent with na.action = na.omit
or na.exclude.

%prep
%setup -q -c -n %{packname}
#Fix permissions
find -type f | xargs chmod -x
#Fix encoding
iconv -f iso-8859-1 -t utf-8 < car/NEWS | tr -d '\r' > car/NEWS.utf-8
touch -r car/NEWS car/NEWS.utf-8
mv car/NEWS.utf-8 car/NEWS

%build

%install
mkdir -p $RPM_BUILD_ROOT%{_datadir}/R/library
%{_bindir}/R CMD INSTALL -l $RPM_BUILD_ROOT%{_datadir}/R/library %{packname}
# Clean up in advance of check
test -d %{packname}/src && (cd %{packname}/src; rm -f *.o *.so)
rm -rf $RPM_BUILD_ROOT%{_datadir}/R/library/R.css

%check
# Use --no-install until R-leaps is available
%{_bindir}/R CMD check --no-install %{packname}

%files
%dir %{_datadir}/R/library/%{packname}
%doc %{_datadir}/R/library/%{packname}/doc/
%doc %{_datadir}/R/library/%{packname}/html/
%doc %{_datadir}/R/library/%{packname}/CITATION
%doc %{_datadir}/R/library/%{packname}/DESCRIPTION
%doc %{_datadir}/R/library/%{packname}/NEWS
%{_datadir}/R/library/%{packname}/INDEX
%{_datadir}/R/library/%{packname}/NAMESPACE
%{_datadir}/R/library/%{packname}/Meta
%{_datadir}/R/library/%{packname}/R
%{_datadir}/R/library/%{packname}/data
%{_datadir}/R/library/%{packname}/help

%changelog
