Group: Engineering
# BEGIN SourceDeps(oneline):
BuildRequires: texinfo
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		c-graph
Version:	2.0.1
Release:	alt2_11
License:	GPLv3+
Summary:	Convolution Graph
URL:		http://www.gnu.org/software/%{name}
Source0:	http://ftp.gnu.org/gnu/c-graph/%{name}-%{version}.tar.gz
BuildRequires:	gcc-fortran
BuildRequires:	help2man
Requires:	coreutils
Requires:	gnuplot-qt
Requires:	ImageMagick-tools
Requires:	less
Requires:	termutils
Source44: import.info

%description
Convolution Theorem Visualization

Convolution is a core concept in today's cutting-edge technologies of
deep learning and computer vision. Singularly cogent in application to
digital signal processing, the convolution theorem is regarded as the
most powerful tool in modern scientific analysis. Long utilised for
accelerating the application of filters to images, fast training of
convolutional neural networks exploit the convolution theorem to accelerate
training and inference in the ubiquitous applications of computer vision
that, today, are at the vanguard of the evolving artificially intelligent
world in which we are becoming increasingly immersed.

Coded in modern Fortran, GNU C-Graph is the de facto tool for visualizing
convolution in university courses worldwide. "C-Graph" stands for
"Convolution Graph" - Free Software that makes learning about convolution
easy!

%prep
%setup -q

%build
%configure
# remove \r\n line endings
sed -e 's|\r||' README > README.new
touch -r README.new README
mv README.new README
%make_build FCFLAGS="$FFLAGS"

%install
make install DESTDIR=%{buildroot}

# must be created when installing info
rm -f %{buildroot}%{_infodir}/dir

%files
%{_bindir}/%{name}
%{_datadir}/%{name}
#doc %{_docdir}/%{name}
%doc %{_infodir}/%{name}*
%doc %{_mandir}/man1/%{name}.1*

%changelog
